/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.authentication.addon;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.client.socket.PacketReader;
import com.singlestore.jdbc.client.socket.PacketWriter;
import com.singlestore.jdbc.plugin.authentication.AuthenticationPlugin;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class ClearPasswordPlugin
implements AuthenticationPlugin {
    public static final String TYPE = "mysql_clear_password";
    private String authenticationData;

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void initialize(String authenticationData, byte[] authData, Configuration conf) {
        this.authenticationData = authenticationData;
    }

    @Override
    public ReadableByteBuf process(PacketWriter out, PacketReader in, Context context) throws IOException {
        if (this.authenticationData == null) {
            out.writeEmptyPacket();
        } else {
            byte[] bytePwd = this.authenticationData.getBytes(StandardCharsets.UTF_8);
            out.writeBytes(bytePwd);
            out.writeByte(0);
            out.flush();
        }
        return in.readPacket(true);
    }
}

