/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.codec.list;

import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.client.socket.PacketWriter;
import com.singlestore.jdbc.codec.Codec;
import com.singlestore.jdbc.codec.DataType;
import com.singlestore.jdbc.codec.list.LocalDateTimeCodec;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import java.io.IOException;
import java.sql.SQLDataException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.EnumSet;

public class InstantCodec
implements Codec<Instant> {
    public static final InstantCodec INSTANCE = new InstantCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.DATETIME, new DataType[]{DataType.DATE, DataType.YEAR, DataType.TIMESTAMP, DataType.VARCHAR, DataType.CHAR, DataType.TIME, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Instant.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Instant.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Instant;
    }

    @Override
    public Instant decodeText(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar calParam) throws SQLDataException {
        LocalDateTime localDateTime = LocalDateTimeCodec.INSTANCE.decodeText(buf, length, column, calParam);
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    @Override
    public Instant decodeBinary(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar calParam) throws SQLDataException {
        LocalDateTime localDateTime = LocalDateTimeCodec.INSTANCE.decodeBinary(buf, length, column, calParam);
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    @Override
    public void encodeText(PacketWriter encoder, Context context, Object val, Calendar calParam, Long maxLen) throws IOException {
        Instant instant = (Instant)val;
        encoder.writeByte(39);
        if (calParam == null && "UTC".equals(ZoneId.systemDefault().getId())) {
            encoder.writeAscii(instant.toString().replace('T', ' '));
            encoder.pos(encoder.pos() - 1);
        } else {
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
            if (calParam != null) {
                zonedDateTime = zonedDateTime.withZoneSameInstant(calParam.getTimeZone().toZoneId());
            }
            encoder.writeAscii(zonedDateTime.format(instant.getNano() != 0 ? LocalDateTimeCodec.TIMESTAMP_FORMAT : LocalDateTimeCodec.TIMESTAMP_FORMAT_NO_FRACTIONAL));
        }
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(PacketWriter encoder, Object value, Calendar calParam, Long maxLength) throws IOException {
        int nano;
        Instant instant = (Instant)value;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        if (calParam != null) {
            zonedDateTime = zonedDateTime.withZoneSameInstant(calParam.getTimeZone().toZoneId());
        }
        if ((nano = zonedDateTime.getNano()) > 0) {
            encoder.writeByte(11);
            encoder.writeShort((short)zonedDateTime.get(ChronoField.YEAR));
            encoder.writeByte(zonedDateTime.get(ChronoField.MONTH_OF_YEAR));
            encoder.writeByte(zonedDateTime.get(ChronoField.DAY_OF_MONTH));
            encoder.writeByte(zonedDateTime.get(ChronoField.HOUR_OF_DAY));
            encoder.writeByte(zonedDateTime.get(ChronoField.MINUTE_OF_HOUR));
            encoder.writeByte(zonedDateTime.get(ChronoField.SECOND_OF_MINUTE));
            encoder.writeInt(nano / 1000);
        } else {
            encoder.writeByte(7);
            encoder.writeShort((short)zonedDateTime.get(ChronoField.YEAR));
            encoder.writeByte(zonedDateTime.get(ChronoField.MONTH_OF_YEAR));
            encoder.writeByte(zonedDateTime.get(ChronoField.DAY_OF_MONTH));
            encoder.writeByte(zonedDateTime.get(ChronoField.HOUR_OF_DAY));
            encoder.writeByte(zonedDateTime.get(ChronoField.MINUTE_OF_HOUR));
            encoder.writeByte(zonedDateTime.get(ChronoField.SECOND_OF_MINUTE));
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATETIME.get();
    }
}

