/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.socket;

import com.singlestore.jdbc.util.MutableInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class CompressOutputStream
extends OutputStream {
    private static final int MIN_COMPRESSION_SIZE = 1536;
    private static final int SMALL_BUFFER_SIZE = 8192;
    private static final int MEDIUM_BUFFER_SIZE = 131072;
    private static final int LARGE_BUFFER_SIZE = 0x100000;
    private static final int MAX_PACKET_LENGTH = 0x1000006;
    private int maxPacketLength = 0x1000006;
    private final OutputStream out;
    private final MutableInt sequence;
    private byte[] buf = new byte[8192];
    private int pos = 7;

    public CompressOutputStream(OutputStream out, MutableInt compressionSequence) {
        this.out = out;
        this.sequence = compressionSequence;
    }

    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxPacketLength = Math.min(0x1000006, maxAllowedPacket + 7);
    }

    private void growBuffer(int len) {
        int bufLength = this.buf.length;
        int newCapacity = bufLength == 8192 ? (len + this.pos < 131072 ? 131072 : (len + this.pos < 0x100000 ? 0x100000 : this.maxPacketLength)) : (bufLength == 131072 ? (len + this.pos < 0x100000 ? 0x100000 : this.maxPacketLength) : this.maxPacketLength);
        byte[] newBuf = new byte[newCapacity];
        System.arraycopy(this.buf, 0, newBuf, 0, this.pos);
        this.buf = newBuf;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.pos + len >= this.buf.length) {
            this.growBuffer(len);
        }
        if (this.pos + len >= this.buf.length) {
            while (len > this.buf.length - this.pos) {
                int writeLen = this.buf.length - this.pos;
                System.arraycopy(b, off, this.buf, this.pos, writeLen);
                this.pos += writeLen;
                this.writeSocket(false);
                off += writeLen;
                len -= writeLen;
            }
        }
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    private void writeSocket(boolean end) throws IOException {
        if (this.pos > 7) {
            if (this.pos < 1536) {
                this.buf[0] = (byte)(this.pos - 7);
                this.buf[1] = (byte)(this.pos - 7 >>> 8);
                this.buf[2] = 0;
                this.buf[3] = this.sequence.incrementAndGet();
                this.buf[4] = 0;
                this.buf[5] = 0;
                this.buf[6] = 0;
                this.out.write(this.buf, 0, this.pos);
            } else {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    try (DeflaterOutputStream deflater = new DeflaterOutputStream(baos);){
                        deflater.write(this.buf, 7, this.pos - 7);
                        deflater.finish();
                    }
                    byte[] compressedBytes = baos.toByteArray();
                    int compressLen = compressedBytes.length;
                    byte[] header = new byte[]{(byte)compressLen, (byte)(compressLen >>> 8), (byte)(compressLen >>> 16), this.sequence.incrementAndGet(), (byte)(this.pos - 7), (byte)(this.pos - 7 >>> 8), (byte)(this.pos - 7 >>> 16)};
                    this.out.write(header, 0, 7);
                    this.out.write(compressedBytes, 0, compressLen);
                }
            }
            if (end && this.buf.length > 8192 && this.pos * 2 < this.buf.length) {
                this.buf = new byte[8192];
            }
            this.pos = 7;
        }
    }

    @Override
    public void flush() throws IOException {
        this.writeSocket(true);
        this.out.flush();
        this.sequence.set((byte)-1);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("NOT EXPECTED !");
    }
}

