/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.internal.Messages;
import com.google.inject.spi.Message;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ApplicationConfigurationException
extends RuntimeException {
    private final Set<Message> errors;
    private final Set<Message> warnings;
    private final List<Message> allMessages;

    public ApplicationConfigurationException(Collection<Message> errors, Collection<Message> warnings) {
        this.errors = ImmutableSet.copyOf(Objects.requireNonNull(errors, "errors is null"));
        Preconditions.checkArgument((!errors.isEmpty() ? 1 : 0) != 0, (Object)"no errors present");
        this.warnings = ImmutableSet.copyOf(Objects.requireNonNull(warnings, "warnings is null"));
        ImmutableList.Builder allMessages = ImmutableList.builder();
        for (Message error : errors) {
            allMessages.add((Object)new Message(error.getSources(), "Error: " + error.getMessage(), error.getCause()));
        }
        for (Message warning : warnings) {
            allMessages.add((Object)new Message(warning.getSources(), "Warning: " + warning.getMessage(), warning.getCause()));
        }
        this.allMessages = allMessages.build();
        this.initCause(Messages.getOnlyCause(this.allMessages));
    }

    public Set<Message> getErrors() {
        return this.errors;
    }

    public Set<Message> getWarnings() {
        return this.warnings;
    }

    @Override
    public String getMessage() {
        return Messages.formatMessages((String)"Configuration errors", this.allMessages);
    }
}

