/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.kinesis.KinesisConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public final class KinesisSessionProperties {
    private static final String TRINO_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String UNSET_TIMESTAMP = "2000-01-01 00:00:00.000";
    private static final String CHECKPOINT_ENABLED = "checkpoint_enabled";
    private static final String ITERATION_NUMBER = "iteration_number";
    private static final String CHECKPOINT_LOGICAL_NAME = "checkpoint_logical_name";
    private static final String MAX_BATCHES = "max_batches";
    private static final String BATCH_SIZE = "batch_size";
    private static final String START_FROM_TIMESTAMP = "start_from_timestamp";
    private static final String STARTING_OFFSET_SECONDS = "starting_offset_seconds";
    private static final String STARTING_TIMESTAMP = "starting_timestamp";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public KinesisSessionProperties(KinesisConfig config) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadata.booleanProperty((String)CHECKPOINT_ENABLED, (String)"Are checkpoints used in this session?", (Boolean)config.isCheckpointEnabled(), (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)ITERATION_NUMBER, (String)"Checkpoint iteration number", (Integer)config.getIteratorNumber(), (boolean)false)).add((Object)PropertyMetadata.stringProperty((String)CHECKPOINT_LOGICAL_NAME, (String)"checkpoint logical name", (String)config.getLogicalProcessName(), (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)MAX_BATCHES, (String)"max number of calls to Kinesis per query", (Integer)config.getMaxBatches(), (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)BATCH_SIZE, (String)"Record limit in calls to Kinesis", (Integer)config.getBatchSize(), (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)START_FROM_TIMESTAMP, (String)"Start from timestamp not trim horizon", (Boolean)config.isIteratorFromTimestamp(), (boolean)false)).add((Object)PropertyMetadata.longProperty((String)STARTING_OFFSET_SECONDS, (String)"Seconds before current time to start iterator", (Long)config.getIteratorOffsetSeconds(), (boolean)false)).add((Object)PropertyMetadata.stringProperty((String)STARTING_TIMESTAMP, (String)"Timestamp in Trino format to start iterator", (String)UNSET_TIMESTAMP, (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isCheckpointEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(CHECKPOINT_ENABLED, Boolean.class);
    }

    public static int getIterationNumber(ConnectorSession session) {
        return (Integer)session.getProperty(ITERATION_NUMBER, Integer.class);
    }

    public static String getCheckpointLogicalName(ConnectorSession session) {
        return (String)session.getProperty(CHECKPOINT_LOGICAL_NAME, String.class);
    }

    public static int getMaxBatches(ConnectorSession session) {
        return (Integer)session.getProperty(MAX_BATCHES, Integer.class);
    }

    public static int getBatchSize(ConnectorSession session) {
        return (Integer)session.getProperty(BATCH_SIZE, Integer.class);
    }

    public static boolean isIteratorFromTimestamp(ConnectorSession session) {
        return (Boolean)session.getProperty(START_FROM_TIMESTAMP, Boolean.class);
    }

    public static long getIteratorOffsetSeconds(ConnectorSession session) {
        return (Long)session.getProperty(STARTING_OFFSET_SECONDS, Long.class);
    }

    public static long getIteratorStartTimestamp(ConnectorSession session) {
        String value = (String)session.getProperty(STARTING_TIMESTAMP, String.class);
        if (value.equals(UNSET_TIMESTAMP)) {
            return 0L;
        }
        return KinesisSessionProperties.getTimestampAsMillis(value, session);
    }

    public static long getTimestampAsMillis(String timestampValue, ConnectorSession session) {
        SimpleDateFormat format = new SimpleDateFormat(TRINO_TIMESTAMP_FORMAT);
        if (!session.getTimeZoneKey().getId().equals(TimeZone.getDefault().getID())) {
            TimeZone sessionTimeZone = TimeZone.getTimeZone(session.getTimeZoneKey().getZoneId());
            format.setTimeZone(sessionTimeZone);
        }
        Date result = format.parse(timestampValue, new ParsePosition(0));
        return result.getTime();
    }
}

