/*
 * Decompiled with CFR 0.152.
 */
package org.ishugaliy.allgood.consistent.hash;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ishugaliy.allgood.consistent.hash.ConsistentHash;
import org.ishugaliy.allgood.consistent.hash.HashRingBuilder;
import org.ishugaliy.allgood.consistent.hash.annotation.Generated;
import org.ishugaliy.allgood.consistent.hash.hasher.Hasher;
import org.ishugaliy.allgood.consistent.hash.node.Node;
import org.ishugaliy.allgood.consistent.hash.partition.Partition;
import org.ishugaliy.allgood.consistent.hash.partition.ReplicationPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HashRing<T extends Node>
implements ConsistentHash<T> {
    private static final Logger LOG = LoggerFactory.getLogger(HashRing.class);
    private final ReadWriteLock mutex = new ReentrantReadWriteLock(true);
    private final Map<T, Set<Partition<T>>> nodes = new HashMap<T, Set<Partition<T>>>();
    private final NavigableMap<Long, Partition<T>> ring = new TreeMap<Long, Partition<T>>();
    private final String name;
    private final Hasher hasher;
    private final int partitionRate;

    HashRing(String name, Hasher hasher, int partitionRate) {
        this.name = name;
        this.hasher = hasher;
        this.partitionRate = partitionRate;
        LOG.info("Ring [{}] created: hasher [{}], partitionRate [{}]", new Object[]{name, hasher, partitionRate});
    }

    public static <T extends Node> HashRingBuilder<T> newBuilder() {
        return new HashRingBuilder();
    }

    @Override
    public boolean add(T node) {
        this.mutex.writeLock().lock();
        try {
            boolean bl = this.addNode(node);
            return bl;
        }
        finally {
            this.mutex.writeLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<T> nodes) {
        this.mutex.writeLock().lock();
        try {
            if (nodes == null) {
                nodes = Collections.emptyList();
            }
            boolean bl = !(nodes = (Collection)nodes.stream().filter(this::addNode).collect(Collectors.toList())).isEmpty();
            return bl;
        }
        finally {
            this.mutex.writeLock().unlock();
        }
    }

    @Override
    public boolean contains(T node) {
        this.mutex.readLock().lock();
        try {
            boolean bl = this.nodes.containsKey(node);
            return bl;
        }
        finally {
            this.mutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(T node) {
        this.mutex.writeLock().lock();
        boolean removed = false;
        try {
            if (this.nodes.containsKey(node)) {
                Set<Partition<Partition>> partitions = this.nodes.remove(node);
                partitions.forEach(p -> {
                    Partition cfr_ignored_0 = (Partition)this.ring.remove(p.getSlot());
                });
                removed = true;
                LOG.info("Ring [{}]: node [{}] removed", (Object)this.name, node);
            }
        }
        finally {
            this.mutex.writeLock().unlock();
        }
        return removed;
    }

    @Override
    public Set<T> getNodes() {
        this.mutex.readLock().lock();
        try {
            HashSet<T> hashSet = new HashSet<T>(this.nodes.keySet());
            return hashSet;
        }
        finally {
            this.mutex.readLock().unlock();
        }
    }

    @Override
    public Optional<T> locate(String key) {
        Optional<T> node;
        this.mutex.readLock().lock();
        try {
            node = this.findNode(key);
        }
        finally {
            this.mutex.readLock().unlock();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<T> locate(String key, int count) {
        Set<T> nodes;
        this.mutex.readLock().lock();
        try {
            nodes = this.findNodes(key, count);
        }
        finally {
            this.mutex.readLock().unlock();
        }
        return nodes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        this.mutex.readLock().lock();
        try {
            int n = this.nodes.size();
            return n;
        }
        finally {
            this.mutex.readLock().unlock();
        }
    }

    public Hasher getHasher() {
        return this.hasher;
    }

    public int getPartitionRate() {
        return this.partitionRate;
    }

    private boolean addNode(T node) {
        boolean added = false;
        if (node != null && !this.nodes.containsKey(node)) {
            Set<Partition<T>> partitions = this.createPartitions(node);
            this.distributePartitions(partitions);
            this.nodes.put(node, partitions);
            LOG.info("Ring [{}]: node [{}] added", (Object)this.name, node);
            added = true;
        }
        return added;
    }

    private Set<Partition<T>> createPartitions(T node) {
        Set<Partition<T>> partitions = IntStream.range(0, this.partitionRate).mapToObj(idx -> new ReplicationPartition<Node>(idx, (Node)node)).collect(Collectors.toSet());
        LOG.debug("Ring [{}]: node [{}] partitions created", (Object)this.name, node);
        return partitions;
    }

    private void distributePartitions(Set<Partition<T>> partitions) {
        for (Partition<T> part : partitions) {
            String pk = part.getPartitionKey();
            long slot = this.findSlot(pk);
            part.setSlot(slot);
            this.ring.put(slot, part);
            LOG.debug("Ring [{}]: node [{}] partitions distributed", (Object)this.name, part.getNode());
        }
    }

    private long findSlot(String pk) {
        long slot;
        int seed = 0;
        while (this.ring.containsKey(slot = this.hash(pk, seed++))) {
        }
        return slot;
    }

    private long hash(String key) {
        return this.hash(key, 0);
    }

    private long hash(String key, int seed) {
        return Math.abs(this.hasher.hash(key, seed));
    }

    private Optional<T> findNode(String key) {
        return this.findNodes(key, 1).stream().findAny();
    }

    private Set<T> findNodes(String key, int count) {
        HashSet<T> res = new HashSet<T>();
        if (key != null && count > 0) {
            if (count < this.nodes.size()) {
                long slot = this.hash(key);
                ClockwiseIterator it = new ClockwiseIterator(slot);
                while (it.hasNext() && res.size() < count) {
                    Partition part = (Partition)it.next();
                    res.add(part.getNode());
                }
            } else {
                res.addAll(this.nodes.keySet());
            }
        }
        LOG.debug("Ring [{}]: key [{}] located nodes [{}]", new Object[]{this.name, key, res});
        return res;
    }

    @Generated
    public String toString() {
        return new StringJoiner(", ", HashRing.class.getSimpleName() + "[", "]").add("nodes= " + this.nodes.size()).add("name= '" + this.name + "'").add("hasher= " + this.hasher).add("partitionRate= " + this.partitionRate).toString();
    }

    private class ClockwiseIterator
    implements Iterator<Partition<T>> {
        private final Iterator<Partition<T>> head;
        private final Iterator<Partition<T>> tail;

        public ClockwiseIterator(long slot) {
            this.head = HashRing.this.ring.headMap(slot).values().iterator();
            this.tail = HashRing.this.ring.tailMap(slot).values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.head.hasNext() || this.tail.hasNext();
        }

        @Override
        public Partition<T> next() {
            return this.tail.hasNext() ? this.tail.next() : this.head.next();
        }
    }
}

