/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi.fop;

import com.qubole.rubix.spi.fop.ObjectPool;

public class Poolable<T>
implements AutoCloseable {
    private T object;
    private ObjectPool<T> pool;
    private String host;
    private long lastAccessTs;

    public Poolable(T t, ObjectPool<T> pool, String host) {
        this.object = t;
        this.pool = pool;
        this.host = host;
        this.lastAccessTs = System.currentTimeMillis();
    }

    public T getObject() {
        return this.object;
    }

    public ObjectPool<T> getPool() {
        return this.pool;
    }

    public String getHost() {
        return this.host;
    }

    public void returnObject() {
        this.pool.returnObject(this);
    }

    public long getLastAccessTs() {
        return this.lastAccessTs;
    }

    public void setLastAccessTs(long lastAccessTs) {
        this.lastAccessTs = lastAccessTs;
    }

    public void destroy() {
        this.object = null;
        this.pool = null;
        this.host = null;
    }

    @Override
    public void close() {
        this.returnObject();
    }
}

