/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper.validation;

import com.qubole.rubix.bookkeeper.validation.FileValidatorResult;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class FileValidatorVisitor
extends SimpleFileVisitor<Path> {
    private static final Log log = LogFactory.getLog(FileValidatorVisitor.class);
    private static String metadataFileSuffix;
    private final Configuration conf;
    private int successes;
    private int totalCacheFiles;
    private final Set<String> filesWithoutMd = new HashSet<String>();

    public FileValidatorVisitor(Configuration conf) {
        this.conf = conf;
        metadataFileSuffix = CacheConfig.getCacheMetadataFileSuffix(conf);
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (!CacheUtil.isMetadataFile(file.toString(), this.conf)) {
            ++this.totalCacheFiles;
            String fileName = file.toString();
            int generationNumber = Integer.parseInt(fileName.substring(fileName.indexOf("_g") + 2));
            Path mdFile = file.resolveSibling(file.getFileName() + metadataFileSuffix + generationNumber);
            if (Files.exists(mdFile, new LinkOption[0])) {
                ++this.successes;
            } else {
                this.filesWithoutMd.add(file.toString());
            }
        }
        return super.visitFile(file, attrs);
    }

    public FileValidatorResult getResult() {
        return new FileValidatorResult(this.successes, this.totalCacheFiles, this.filesWithoutMd);
    }
}

