/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.trino.hadoop.$internal.org.apache.avro.util.Utf8;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInited;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobInitedEvent
implements HistoryEvent {
    private JobInited datum = new JobInited();

    public JobInitedEvent(JobID id, long launchTime, int totalMaps, int totalReduces, String jobStatus, boolean uberized) {
        this.datum.setJobid(new Utf8(id.toString()));
        this.datum.setLaunchTime(launchTime);
        this.datum.setTotalMaps(totalMaps);
        this.datum.setTotalReduces(totalReduces);
        this.datum.setJobStatus(new Utf8(jobStatus));
        this.datum.setUberized(uberized);
    }

    JobInitedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobInited)datum;
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.getJobid().toString());
    }

    public long getLaunchTime() {
        return this.datum.getLaunchTime();
    }

    public int getTotalMaps() {
        return this.datum.getTotalMaps();
    }

    public int getTotalReduces() {
        return this.datum.getTotalReduces();
    }

    public String getStatus() {
        return this.datum.getJobStatus().toString();
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_INITED;
    }

    public boolean getUberized() {
        return this.datum.getUberized();
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase(this.getEventType().name()));
        tEvent.addInfo("START_TIME", (Object)this.getLaunchTime());
        tEvent.addInfo("STATUS", (Object)this.getStatus());
        tEvent.addInfo("TOTAL_MAPS", (Object)this.getTotalMaps());
        tEvent.addInfo("TOTAL_REDUCES", (Object)this.getTotalReduces());
        tEvent.addInfo("UBERIZED", (Object)this.getUberized());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

