/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.erasurecode;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedBlockWriter;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructionInfo;
import org.apache.hadoop.hdfs.server.datanode.erasurecode.StripedReconstructor;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
class StripedWriter {
    private static final Logger LOG = DataNode.LOG;
    private static final int WRITE_PACKET_SIZE = 65536;
    private final StripedReconstructor reconstructor;
    private final DataNode datanode;
    private final Configuration conf;
    private final int dataBlkNum;
    private final int parityBlkNum;
    private boolean[] targetsStatus;
    private final DatanodeInfo[] targets;
    private final short[] targetIndices;
    private boolean hasValidTargets;
    private final StorageType[] targetStorageTypes;
    private final String[] targetStorageIds;
    private StripedBlockWriter[] writers;
    private int maxChunksPerPacket;
    private byte[] packetBuf;
    private byte[] checksumBuf;
    private int bytesPerChecksum;
    private int checksumSize;

    StripedWriter(StripedReconstructor reconstructor, DataNode datanode, Configuration conf, StripedReconstructionInfo stripedReconInfo) {
        this.reconstructor = reconstructor;
        this.datanode = datanode;
        this.conf = conf;
        this.dataBlkNum = stripedReconInfo.getEcPolicy().getNumDataUnits();
        this.parityBlkNum = stripedReconInfo.getEcPolicy().getNumParityUnits();
        this.targets = stripedReconInfo.getTargets();
        assert (this.targets != null);
        this.targetStorageTypes = stripedReconInfo.getTargetStorageTypes();
        assert (this.targetStorageTypes != null);
        this.targetStorageIds = stripedReconInfo.getTargetStorageIds();
        assert (this.targetStorageIds != null);
        this.writers = new StripedBlockWriter[this.targets.length];
        this.targetIndices = new short[this.targets.length];
        Preconditions.checkArgument(this.targetIndices.length <= this.dataBlkNum + this.parityBlkNum - reconstructor.getNumLiveBlocks(), "Reconstruction work gets too much targets.");
        Preconditions.checkArgument(this.targetIndices.length <= this.parityBlkNum, "Too much missed striped blocks.");
        this.initTargetIndices();
        long maxTargetLength = 0L;
        for (short targetIndex : this.targetIndices) {
            maxTargetLength = Math.max(maxTargetLength, reconstructor.getBlockLen(targetIndex));
        }
        reconstructor.setMaxTargetLength(maxTargetLength);
        this.targetsStatus = new boolean[this.targets.length];
    }

    void init() throws IOException {
        DataChecksum checksum = this.reconstructor.getChecksum();
        this.checksumSize = checksum.getChecksumSize();
        this.bytesPerChecksum = checksum.getBytesPerChecksum();
        int chunkSize = this.bytesPerChecksum + this.checksumSize;
        this.maxChunksPerPacket = Math.max((65536 - PacketHeader.PKT_MAX_HEADER_LEN) / chunkSize, 1);
        int maxPacketSize = chunkSize * this.maxChunksPerPacket + PacketHeader.PKT_MAX_HEADER_LEN;
        this.packetBuf = new byte[maxPacketSize];
        int tmpLen = this.checksumSize * (this.reconstructor.getBufferSize() / this.bytesPerChecksum);
        this.checksumBuf = new byte[tmpLen];
        if (this.initTargetStreams() == 0) {
            String error = "All targets are failed.";
            throw new IOException(error);
        }
    }

    private void initTargetIndices() {
        BitSet bitset = this.reconstructor.getLiveBitSet();
        int m3 = 0;
        this.hasValidTargets = false;
        for (int i = 0; i < this.dataBlkNum + this.parityBlkNum; ++i) {
            if (bitset.get(i) || this.reconstructor.getBlockLen(i) <= 0L || m3 >= this.targets.length) continue;
            this.targetIndices[m3++] = (short)i;
            this.hasValidTargets = true;
        }
    }

    int transferData2Targets() {
        int nSuccess = 0;
        for (int i = 0; i < this.targets.length; ++i) {
            if (!this.targetsStatus[i]) continue;
            boolean success = false;
            try {
                this.writers[i].transferData2Target(this.packetBuf);
                ++nSuccess;
                success = true;
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
            }
            this.targetsStatus[i] = success;
        }
        return nSuccess;
    }

    void endTargetBlocks() {
        for (int i = 0; i < this.targets.length; ++i) {
            if (!this.targetsStatus[i]) continue;
            try {
                this.writers[i].endTargetBlock(this.packetBuf);
                continue;
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
            }
        }
    }

    int initTargetStreams() {
        int nSuccess = 0;
        for (short i = 0; i < this.targets.length; i = (short)(i + 1)) {
            try {
                this.writers[i] = this.createWriter(i);
                ++nSuccess;
                this.targetsStatus[i] = true;
                continue;
            }
            catch (Throwable e) {
                LOG.warn(e.getMessage());
            }
        }
        return nSuccess;
    }

    private StripedBlockWriter createWriter(short index) throws IOException {
        return new StripedBlockWriter(this, this.datanode, this.conf, this.reconstructor.getBlock(this.targetIndices[index]), this.targets[index], this.targetStorageTypes[index], this.targetStorageIds[index]);
    }

    ByteBuffer allocateWriteBuffer() {
        return this.reconstructor.allocateBuffer(this.reconstructor.getBufferSize());
    }

    int getTargets() {
        return this.targets.length;
    }

    private int getRealTargets() {
        int m3 = 0;
        for (int i = 0; i < this.targets.length; ++i) {
            if (!this.targetsStatus[i]) continue;
            ++m3;
        }
        return m3;
    }

    int[] getRealTargetIndices() {
        int realTargets = this.getRealTargets();
        int[] results = new int[realTargets];
        int m3 = 0;
        for (int i = 0; i < this.targets.length; ++i) {
            if (!this.targetsStatus[i]) continue;
            results[m3++] = this.targetIndices[i];
        }
        return results;
    }

    ByteBuffer[] getRealTargetBuffers(int toReconstructLen) {
        int numGood = this.getRealTargets();
        ByteBuffer[] outputs = new ByteBuffer[numGood];
        int m3 = 0;
        for (int i = 0; i < this.targets.length; ++i) {
            if (!this.targetsStatus[i]) continue;
            this.writers[i].getTargetBuffer().limit(toReconstructLen);
            outputs[m3++] = this.writers[i].getTargetBuffer();
        }
        return outputs;
    }

    void updateRealTargetBuffers(int toReconstructLen) {
        for (int i = 0; i < this.targets.length; ++i) {
            if (!this.targetsStatus[i]) continue;
            long blockLen = this.reconstructor.getBlockLen(this.targetIndices[i]);
            long remaining = blockLen - this.reconstructor.getPositionInBlock();
            if (remaining <= 0L) {
                this.writers[i].getTargetBuffer().limit(0);
                continue;
            }
            if (remaining >= (long)toReconstructLen) continue;
            this.writers[i].getTargetBuffer().limit((int)remaining);
        }
    }

    byte[] getChecksumBuf() {
        return this.checksumBuf;
    }

    int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    int getChecksumSize() {
        return this.checksumSize;
    }

    DataChecksum getChecksum() {
        return this.reconstructor.getChecksum();
    }

    int getMaxChunksPerPacket() {
        return this.maxChunksPerPacket;
    }

    CachingStrategy getCachingStrategy() {
        return this.reconstructor.getCachingStrategy();
    }

    InetSocketAddress getSocketAddress4Transfer(DatanodeInfo target) {
        return this.reconstructor.getSocketAddress4Transfer(target);
    }

    StripedReconstructor getReconstructor() {
        return this.reconstructor;
    }

    boolean hasValidTargets() {
        return this.hasValidTargets;
    }

    void clearBuffers() {
        for (StripedBlockWriter writer : this.writers) {
            ByteBuffer targetBuffer;
            ByteBuffer byteBuffer = targetBuffer = writer != null ? writer.getTargetBuffer() : null;
            if (targetBuffer == null) continue;
            targetBuffer.clear();
        }
    }

    void close() {
        for (StripedBlockWriter writer : this.writers) {
            ByteBuffer targetBuffer;
            ByteBuffer byteBuffer = targetBuffer = writer != null ? writer.getTargetBuffer() : null;
            if (targetBuffer == null) continue;
            this.reconstructor.freeBuffer(targetBuffer);
            writer.freeTargetBuffer();
        }
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.writers[i] == null) continue;
            this.writers[i].close();
        }
    }
}

