/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.store.audit;

import io.trino.hadoop.;
import java.util.concurrent.Callable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.apache.hadoop.util.functional.InvocationRaisingIOE;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class AuditingFunctions {
    private AuditingFunctions() {
    }

    public static <T> CallableRaisingIOE<T> withinAuditSpan(@.Nullable AuditSpan auditSpan, CallableRaisingIOE<T> operation) {
        return auditSpan == null ? operation : () -> {
            auditSpan.activate();
            return operation.apply();
        };
    }

    public static InvocationRaisingIOE withinAuditSpan(@.Nullable AuditSpan auditSpan, InvocationRaisingIOE operation) {
        return auditSpan == null ? operation : () -> {
            auditSpan.activate();
            operation.apply();
        };
    }

    public static <T, R> FunctionRaisingIOE<T, R> withinAuditSpan(@.Nullable AuditSpan auditSpan, FunctionRaisingIOE<T, R> operation) {
        return auditSpan == null ? operation : x -> {
            auditSpan.activate();
            return operation.apply(x);
        };
    }

    public static <T> Callable<T> callableWithinAuditSpan(@.Nullable AuditSpan auditSpan, Callable<T> operation) {
        return auditSpan == null ? operation : () -> {
            auditSpan.activate();
            return operation.call();
        };
    }
}

