/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client;

import io.trino.hadoop.$internal.org.apache.kerby.KOptions;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbClient;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbClientBase;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbConfig;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbOption;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.TokenOption;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KrbToken;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import io.trino.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import java.io.File;

public class KrbTokenClient
extends KrbClientBase {
    public KrbTokenClient() throws KrbException {
    }

    public KrbTokenClient(KrbConfig krbConfig) {
        super(krbConfig);
    }

    public KrbTokenClient(File confDir) throws KrbException {
        super(confDir);
    }

    public KrbTokenClient(KrbClient krbClient) {
        super(krbClient);
    }

    public TgtTicket requestTgt(KrbToken token, String armorCache) throws KrbException {
        if (!token.isIdToken()) {
            throw new IllegalArgumentException("Identity token is expected");
        }
        KOptions requestOptions = new KOptions();
        requestOptions.add(TokenOption.USER_ID_TOKEN, token);
        requestOptions.add(KrbOption.ARMOR_CACHE, armorCache);
        return this.requestTgt(requestOptions);
    }

    public TgtTicket requestTgt(KrbToken token, TgtTicket tgt) throws KrbException {
        if (!token.isIdToken()) {
            throw new IllegalArgumentException("Identity token is expected");
        }
        KOptions requestOptions = new KOptions();
        requestOptions.add(TokenOption.USER_ID_TOKEN, token);
        requestOptions.add(KrbOption.TGT, tgt);
        return this.requestTgt(requestOptions);
    }

    public SgtTicket requestSgt(KrbToken token, String serverPrincipal, String armorCache) throws KrbException {
        if (!token.isAcToken()) {
            throw new IllegalArgumentException("Access token is expected");
        }
        KOptions requestOptions = new KOptions();
        requestOptions.add(TokenOption.USER_AC_TOKEN, token);
        requestOptions.add(KrbOption.ARMOR_CACHE, armorCache);
        requestOptions.add(KrbOption.SERVER_PRINCIPAL, serverPrincipal);
        return this.requestSgt(requestOptions);
    }

    public SgtTicket requestSgt(KrbToken token, String serverPrincipal, TgtTicket tgt) throws KrbException {
        if (!token.isAcToken()) {
            throw new IllegalArgumentException("Access token is expected");
        }
        KOptions requestOptions = new KOptions();
        requestOptions.add(TokenOption.USER_AC_TOKEN, token);
        requestOptions.add(KrbOption.TGT, tgt);
        requestOptions.add(KrbOption.SERVER_PRINCIPAL, serverPrincipal);
        return this.requestSgt(requestOptions);
    }
}

