/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray.buffer;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public class UnsafeUtil {
    public static Unsafe unsafe = UnsafeUtil.getUnsafe();
    private static Constructor<?> dbbCC = UnsafeUtil.findDirectByteBufferConstructor();

    public static Unsafe getUnsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)Unsafe.class.cast(field.get(null));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException("sun.misc.Unsafe is not available in this JVM");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("sun.misc.Unsafe is not available in this JVM");
        }
    }

    private static Constructor<?> findDirectByteBufferConstructor() {
        try {
            return Class.forName("java.nio.DirectByteBuffer").getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(String.format("Failed to find java.nio.DirectByteBuffer: $s", classNotFoundException.getMessage()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(String.format("Failed to find constructor f java.nio.DirectByteBuffer: $s", noSuchMethodException.getMessage()));
        }
    }

    public static ByteBuffer newDirectByteBuffer(long l, int n, Object object) {
        dbbCC.setAccessible(true);
        Object var4_3 = null;
        try {
            var4_3 = dbbCC.newInstance(new Long(l), new Integer(n), object);
            return (ByteBuffer)ByteBuffer.class.cast(var4_3);
        }
        catch (Exception exception) {
            throw new IllegalStateException(String.format("Failed to create DirectByteBuffer: %s", exception.getMessage()));
        }
    }
}

