/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray.buffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.WritableByteChannel;
import xerial.larray.buffer.LBuffer;
import xerial.larray.buffer.LBufferConfig;
import xerial.larray.buffer.Memory;
import xerial.larray.buffer.UnsafeUtil;
import xerial.larray.buffer.WrappedLBuffer;
import xerial.larray.buffer.WritableChannelWrap;

public class LBufferAPI {
    public Memory m;

    public LBufferAPI() {
    }

    public LBufferAPI(Memory memory) {
        this.m = memory;
    }

    public byte apply(int n) {
        return this.getByte(n);
    }

    public void update(int n, byte by) {
        this.putByte(n, by);
    }

    public byte apply(long l) {
        return this.getByte(l);
    }

    public void update(long l, byte by) {
        this.putByte(l, by);
    }

    public void release() {
        LBufferConfig.allocator.release(this.m);
        this.m = null;
    }

    public long address() {
        return this.m.address();
    }

    public long size() {
        return this.m.dataSize();
    }

    public void clear() {
        this.fill(0L, this.size(), (byte)0);
    }

    public void fill(long l, long l2, byte by) {
        UnsafeUtil.unsafe.setMemory(this.address() + l, l2, by);
    }

    public byte getByte(int n) {
        return UnsafeUtil.unsafe.getByte(this.address() + (long)n);
    }

    public char getChar(int n) {
        return UnsafeUtil.unsafe.getChar(this.address() + (long)n);
    }

    public short getShort(int n) {
        return UnsafeUtil.unsafe.getShort(this.address() + (long)n);
    }

    public int getInt(int n) {
        return UnsafeUtil.unsafe.getInt(this.address() + (long)n);
    }

    public float getFloat(int n) {
        return UnsafeUtil.unsafe.getFloat(this.address() + (long)n);
    }

    public long getLong(int n) {
        return UnsafeUtil.unsafe.getLong(this.address() + (long)n);
    }

    public double getDouble(int n) {
        return UnsafeUtil.unsafe.getDouble(this.address() + (long)n);
    }

    public void putByte(int n, byte by) {
        UnsafeUtil.unsafe.putByte(this.address() + (long)n, by);
    }

    public void putChar(int n, char c) {
        UnsafeUtil.unsafe.putChar(this.address() + (long)n, c);
    }

    public void putShort(int n, short s) {
        UnsafeUtil.unsafe.putShort(this.address() + (long)n, s);
    }

    public void putInt(int n, int n2) {
        UnsafeUtil.unsafe.putInt(this.address() + (long)n, n2);
    }

    public void putFloat(int n, float f) {
        UnsafeUtil.unsafe.putFloat(this.address() + (long)n, f);
    }

    public void putLong(int n, long l) {
        UnsafeUtil.unsafe.putLong(this.address() + (long)n, l);
    }

    public void putDouble(int n, double d) {
        UnsafeUtil.unsafe.putDouble(this.address() + (long)n, d);
    }

    public byte getByte(long l) {
        return UnsafeUtil.unsafe.getByte(this.address() + l);
    }

    public char getChar(long l) {
        return UnsafeUtil.unsafe.getChar(this.address() + l);
    }

    public short getShort(long l) {
        return UnsafeUtil.unsafe.getShort(this.address() + l);
    }

    public int getInt(long l) {
        return UnsafeUtil.unsafe.getInt(this.address() + l);
    }

    public float getFloat(long l) {
        return UnsafeUtil.unsafe.getFloat(this.address() + l);
    }

    public long getLong(long l) {
        return UnsafeUtil.unsafe.getLong(this.address() + l);
    }

    public double getDouble(long l) {
        return UnsafeUtil.unsafe.getDouble(this.address() + l);
    }

    public void putByte(long l, byte by) {
        UnsafeUtil.unsafe.putByte(this.address() + l, by);
    }

    public void putChar(long l, char c) {
        UnsafeUtil.unsafe.putChar(this.address() + l, c);
    }

    public void putShort(long l, short s) {
        UnsafeUtil.unsafe.putShort(this.address() + l, s);
    }

    public void putInt(long l, int n) {
        UnsafeUtil.unsafe.putInt(this.address() + l, n);
    }

    public void putFloat(long l, float f) {
        UnsafeUtil.unsafe.putFloat(this.address() + l, f);
    }

    public void putLong(long l, long l2) {
        UnsafeUtil.unsafe.putLong(this.address() + l, l2);
    }

    public void putDouble(long l, double d) {
        UnsafeUtil.unsafe.putDouble(this.address() + l, d);
    }

    public void copyTo(int n, byte[] byArray, int n2, int n3) {
        int n4 = n2;
        for (ByteBuffer byteBuffer : this.toDirectByteBuffers(n, n3)) {
            int n5 = byteBuffer.remaining();
            if (n4 + n5 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException(String.format("cursor + bbSize = %,d", n4 + n5));
            }
            byteBuffer.get(byArray, n4, n5);
            n4 += n5;
        }
    }

    public void copyTo(long l, LBufferAPI lBufferAPI, long l2, long l3) {
        UnsafeUtil.unsafe.copyMemory(this.address() + l, lBufferAPI.address() + l2, l3);
    }

    public LBuffer slice(long l, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException(String.format("invalid range %,d to %,d", l, l2));
        }
        long l3 = l2 - l;
        LBuffer lBuffer = new LBuffer(l3);
        this.copyTo(l, lBuffer, 0L, l3);
        return lBuffer;
    }

    public WrappedLBuffer view(long l, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException(String.format("invalid range %,d to %,d", l, l2));
        }
        return new WrappedLBuffer(this.m, l + this.offset(), l2 - l);
    }

    public byte[] toArray() {
        if (this.size() > Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot create byte array of more than 2GB");
        }
        int n = (int)this.size();
        ByteBuffer byteBuffer = this.toDirectByteBuffer(0L, n);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray, 0, n);
        return byArray;
    }

    public void writeTo(FileChannel fileChannel) throws IOException {
        fileChannel.write(this.toDirectByteBuffers());
    }

    public void writeTo(GatheringByteChannel gatheringByteChannel) throws IOException {
        gatheringByteChannel.write(this.toDirectByteBuffers());
    }

    public void writeTo(WritableByteChannel writableByteChannel) throws IOException {
        for (ByteBuffer byteBuffer : this.toDirectByteBuffers()) {
            writableByteChannel.write(byteBuffer);
        }
    }

    public void writeTo(File file) throws IOException {
        try (FileChannel fileChannel = new FileOutputStream(file).getChannel();){
            this.writeTo(fileChannel);
        }
    }

    public int readFrom(byte[] byArray, long l) {
        return this.readFrom(byArray, 0, l, byArray.length);
    }

    public int readFrom(byte[] byArray, int n, long l, int n2) {
        int n3 = (int)Math.min((long)(byArray.length - n), Math.min(this.size() - l, (long)n2));
        ByteBuffer byteBuffer = this.toDirectByteBuffer(l, n3);
        byteBuffer.position(0);
        byteBuffer.put(byArray, n, n3);
        return n3;
    }

    public int readFrom(ByteBuffer byteBuffer, long l) {
        if ((long)byteBuffer.remaining() + l >= this.size()) {
            throw new BufferOverflowException();
        }
        int n = byteBuffer.remaining();
        ByteBuffer byteBuffer2 = this.toDirectByteBuffer(l, n);
        byteBuffer2.position(0);
        byteBuffer2.put(byteBuffer);
        return n;
    }

    public static LBuffer loadFrom(File file) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        long l = fileChannel.size();
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot load from file more than 2GB: " + file);
        }
        LBuffer lBuffer = new LBuffer((int)l);
        WritableChannelWrap writableChannelWrap = new WritableChannelWrap(lBuffer);
        for (long i = 0L; i < l; i += fileChannel.transferTo(0L, l, writableChannelWrap)) {
        }
        return lBuffer;
    }

    public ByteBuffer[] toDirectByteBuffers() {
        return this.toDirectByteBuffers(0L, this.size());
    }

    public ByteBuffer[] toDirectByteBuffers(long l, long l2) {
        long l3;
        long l4 = Integer.MAX_VALUE;
        long l5 = l + l2;
        int n = (int)((l2 + (l4 - 1L)) / l4);
        ByteBuffer[] byteBufferArray = new ByteBuffer[n];
        int n2 = 0;
        for (long i = l; i < l5; i += l3) {
            l3 = Math.min(l5 - i, l4);
            byteBufferArray[n2++] = UnsafeUtil.newDirectByteBuffer(this.address() + i, (int)l3, this).order(ByteOrder.nativeOrder());
        }
        return byteBufferArray;
    }

    public ByteBuffer toDirectByteBuffer(long l, int n) {
        return UnsafeUtil.newDirectByteBuffer(this.address() + l, n, this);
    }

    protected long offset() {
        return 0L;
    }
}

