/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.lite;

import alluxio.shaded.client.software.amazon.ionIonCatalog;
import alluxio.shaded.client.software.amazon.ionIonContainer;
import alluxio.shaded.client.software.amazon.ionIonDatagram;
import alluxio.shaded.client.software.amazon.ionIonException;
import alluxio.shaded.client.software.amazon.ionIonLoader;
import alluxio.shaded.client.software.amazon.ionIonReader;
import alluxio.shaded.client.software.amazon.ionIonStruct;
import alluxio.shaded.client.software.amazon.ionIonSystem;
import alluxio.shaded.client.software.amazon.ionIonTimestamp;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonValue;
import alluxio.shaded.client.software.amazon.ionIonWriter;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionSymbolToken;
import alluxio.shaded.client.software.amazon.ionUnexpectedEofException;
import alluxio.shaded.client.software.amazon.ionUnsupportedIonVersionException;
import alluxio.shaded.client.software.amazon.ionValueFactory;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonBinaryWriterBuilder;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonReaderFactory;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonSystem;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonWriterFactory;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateUtils;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonContainerLite;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonDatagramLite;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonLoaderLite;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonSymbolLite;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonTimestampLite;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonValueLite;
import alluxio.shaded.client.software.amazon.ionimpl.lite.ValueFactoryLite;
import alluxio.shaded.client.software.amazon.ionsystem.IonTextWriterBuilder;
import alluxio.shaded.client.software.amazon.ionutil.IonTextUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IonSystemLite
extends ValueFactoryLite
implements PrivateIonSystem {
    private final ionSymbolTable _system_symbol_table;
    private final ionIonCatalog _catalog;
    private ValueFactoryLite _value_factory;
    private final ionIonLoader _loader;
    private final IonTextWriterBuilder myTextWriterBuilder;
    private final PrivateIonBinaryWriterBuilder myBinaryWriterBuilder;

    public IonSystemLite(IonTextWriterBuilder twb, PrivateIonBinaryWriterBuilder bwb) {
        ionIonCatalog catalog = twb.getCatalog();
        assert (catalog != null);
        assert (catalog == bwb.getCatalog());
        this._catalog = catalog;
        this._loader = new IonLoaderLite(this, catalog);
        this._system_symbol_table = bwb.getInitialSymbolTable();
        assert (this._system_symbol_table.isSystemTable());
        this.myTextWriterBuilder = twb.immutable();
        this._value_factory = this;
        this._value_factory.set_system(this);
        bwb.setSymtabValueFactory(this._value_factory);
        this.myBinaryWriterBuilder = bwb.immutable();
    }

    @Override
    public boolean isStreamCopyOptimized() {
        return this.myBinaryWriterBuilder.isStreamCopyOptimized();
    }

    @Override
    public <T extends ionIonValue> T clone(T value) throws ionIonException {
        if (value.getSystem() == this) {
            return (T)value.clone();
        }
        if (value instanceof ionIonDatagram) {
            ionIonDatagram datagram = this.newDatagram();
            ionIonWriter writer = PrivateIonWriterFactory.makeWriter(datagram);
            ionIonReader reader = PrivateIonReaderFactory.makeSystemReader(value.getSystem(), value);
            try {
                writer.writeValues(reader);
            }
            catch (IOException e) {
                throw new ionIonException(e);
            }
            return (T)datagram;
        }
        ionIonReader reader = this.newReader(value);
        reader.next();
        return (T)this.newValue(reader);
    }

    @Override
    public ionIonCatalog getCatalog() {
        return this._catalog;
    }

    @Override
    public synchronized ionIonLoader getLoader() {
        return this._loader;
    }

    @Override
    public ionIonLoader newLoader() {
        return new IonLoaderLite(this, this._catalog);
    }

    @Override
    public ionIonLoader newLoader(ionIonCatalog catalog) {
        if (catalog == null) {
            catalog = this.getCatalog();
        }
        return new IonLoaderLite(this, catalog);
    }

    @Override
    public final ionSymbolTable getSystemSymbolTable() {
        return this._system_symbol_table;
    }

    @Override
    public ionSymbolTable getSystemSymbolTable(String ionVersionId) throws ionUnsupportedIonVersionException {
        if (!"$ion_1_0".equals(ionVersionId)) {
            throw new ionUnsupportedIonVersionException(ionVersionId);
        }
        return this.getSystemSymbolTable();
    }

    @Override
    public Iterator<ionIonValue> iterate(Reader ionText) {
        ionIonReader reader = PrivateIonReaderFactory.makeReader((ionIonSystem)this, this._catalog, ionText);
        ReaderIterator iterator = new ReaderIterator(this, reader);
        return iterator;
    }

    @Override
    public Iterator<ionIonValue> iterate(InputStream ionData) {
        ionIonReader reader = this.newReader(ionData);
        ReaderIterator iterator = new ReaderIterator(this, reader);
        return iterator;
    }

    @Override
    public Iterator<ionIonValue> iterate(String ionText) {
        ionIonReader reader = PrivateIonReaderFactory.makeReader((ionIonSystem)this, this._catalog, ionText);
        ReaderIterator iterator = new ReaderIterator(this, reader);
        return iterator;
    }

    @Override
    public Iterator<ionIonValue> iterate(byte[] ionData) {
        ionIonReader reader = PrivateIonReaderFactory.makeReader((ionIonSystem)this, this._catalog, ionData);
        ReaderIterator iterator = new ReaderIterator(this, reader);
        return iterator;
    }

    @Override
    public ionIonWriter newBinaryWriter(OutputStream out, ionSymbolTable ... imports) {
        return this.myBinaryWriterBuilder.withImports(imports).build(out);
    }

    @Override
    public ionIonWriter newTextWriter(Appendable out) {
        return this.myTextWriterBuilder.build(out);
    }

    @Override
    public ionIonWriter newTextWriter(Appendable out, ionSymbolTable ... imports) throws IOException {
        return this.myTextWriterBuilder.withImports(imports).build(out);
    }

    @Override
    public ionIonWriter newTextWriter(OutputStream out) {
        return this.myTextWriterBuilder.build(out);
    }

    @Override
    public ionIonWriter newTextWriter(OutputStream out, ionSymbolTable ... imports) throws IOException {
        return this.myTextWriterBuilder.withImports(imports).build(out);
    }

    @Override
    public ionSymbolTable newLocalSymbolTable(ionSymbolTable ... imports) {
        return PrivateUtils.newLocalSymtab((ionValueFactory)this, this.getSystemSymbolTable(), null, imports);
    }

    @Override
    public ionSymbolTable newSharedSymbolTable(ionIonStruct ionRep) {
        return PrivateUtils.newSharedSymtab(ionRep);
    }

    @Override
    public ionSymbolTable newSharedSymbolTable(ionIonReader reader) {
        return PrivateUtils.newSharedSymtab(reader, false);
    }

    @Override
    public ionSymbolTable newSharedSymbolTable(ionIonReader reader, boolean isOnStruct) {
        return PrivateUtils.newSharedSymtab(reader, isOnStruct);
    }

    @Override
    public ionSymbolTable newSharedSymbolTable(String name, int version, Iterator<String> newSymbols, ionSymbolTable ... imports) {
        int priorVersion;
        ArrayList syms = new ArrayList();
        ionSymbolTable prior = null;
        if (version > 1 && ((prior = this._catalog.getTable(name, priorVersion = version - 1)) == null || prior.getVersion() != priorVersion)) {
            String message = "Catalog does not contain symbol table " + IonTextUtils.printString(name) + " version " + priorVersion + " required to create version " + version;
            throw new ionIonException(message);
        }
        for (ionSymbolTable imported : imports) {
            PrivateUtils.addAllNonNull(syms, imported.iterateDeclaredSymbolNames());
        }
        PrivateUtils.addAllNonNull(syms, newSymbols);
        ionSymbolTable st = PrivateUtils.newSharedSymtab(name, version, prior, syms.iterator());
        return st;
    }

    @Override
    public IonValueLite newValue(ionIonReader reader) {
        IonValueLite value = this.load_value_helper(reader, true);
        if (value == null) {
            throw new ionIonException("No value available");
        }
        return value;
    }

    private IonValueLite load_value_helper(ionIonReader reader, boolean isTopLevel) {
        ionSymbolToken[] annotations;
        IonValueLite v;
        boolean symbol_is_present = false;
        ionIonType t = reader.getType();
        if (t == null) {
            return null;
        }
        if (reader.isNullValue()) {
            v = this.newNull(t);
        } else {
            switch (t) {
                case BOOL: {
                    v = this.newBool(reader.booleanValue());
                    break;
                }
                case INT: {
                    v = this.newInt(reader.bigIntegerValue());
                    break;
                }
                case FLOAT: {
                    v = this.newFloat(reader.doubleValue());
                    break;
                }
                case DECIMAL: {
                    v = this.newDecimal(reader.decimalValue());
                    break;
                }
                case TIMESTAMP: {
                    v = this.newTimestamp(reader.timestampValue());
                    break;
                }
                case SYMBOL: {
                    v = this.newSymbol(reader.symbolValue());
                    symbol_is_present = true;
                    break;
                }
                case STRING: {
                    v = this.newString(reader.stringValue());
                    break;
                }
                case CLOB: {
                    v = this.newClob(reader.newBytes());
                    break;
                }
                case BLOB: {
                    v = this.newBlob(reader.newBytes());
                    break;
                }
                case LIST: {
                    v = this.newEmptyList();
                    break;
                }
                case SEXP: {
                    v = this.newEmptySexp();
                    break;
                }
                case STRUCT: {
                    v = this.newEmptyStruct();
                    break;
                }
                default: {
                    throw new ionIonException("unexpected type encountered reading value: " + t.toString());
                }
            }
        }
        if (!isTopLevel && reader.isInStruct()) {
            ionSymbolToken token = reader.getFieldNameSymbol();
            String text = token.getText();
            if (text != null && token.getSid() != -1) {
                token = PrivateUtils.newSymbolToken(text, -1);
            }
            v.setFieldNameSymbol(token);
            symbol_is_present = true;
        }
        if ((annotations = reader.getTypeAnnotationSymbols()).length != 0) {
            for (int i = 0; i < annotations.length; ++i) {
                ionSymbolToken token = annotations[i];
                String text = token.getText();
                if (text == null || token.getSid() == -1) continue;
                annotations[i] = PrivateUtils.newSymbolToken(text, -1);
            }
            v.setTypeAnnotationSymbols(annotations);
            symbol_is_present = true;
        }
        if (!reader.isNullValue()) {
            switch (t) {
                case BOOL: 
                case INT: 
                case FLOAT: 
                case DECIMAL: 
                case TIMESTAMP: 
                case SYMBOL: 
                case STRING: 
                case CLOB: 
                case BLOB: {
                    break;
                }
                case LIST: 
                case SEXP: 
                case STRUCT: {
                    if (!this.load_children((IonContainerLite)v, reader)) break;
                    symbol_is_present = true;
                    break;
                }
                default: {
                    throw new ionIonException("unexpected type encountered reading value: " + t.toString());
                }
            }
        }
        if (symbol_is_present) {
            v._isSymbolPresent(true);
        }
        return v;
    }

    private boolean load_children(IonContainerLite container, ionIonReader reader) {
        ionIonType t;
        boolean symbol_is_present = false;
        reader.stepIn();
        while ((t = reader.next()) != null) {
            IonValueLite child = this.load_value_helper(reader, false);
            container.add(child);
            if (!child._isSymbolPresent()) continue;
            symbol_is_present = true;
        }
        reader.stepOut();
        return symbol_is_present;
    }

    IonValueLite newValue(ionIonType valueType) {
        IonValueLite v;
        if (valueType == null) {
            throw new IllegalArgumentException("the value type must be specified");
        }
        switch (valueType) {
            case NULL: {
                v = this.newNull();
                break;
            }
            case BOOL: {
                v = this.newNullBool();
                break;
            }
            case INT: {
                v = this.newNullInt();
                break;
            }
            case FLOAT: {
                v = this.newNullFloat();
                break;
            }
            case DECIMAL: {
                v = this.newNullDecimal();
                break;
            }
            case TIMESTAMP: {
                v = this.newNullTimestamp();
                break;
            }
            case SYMBOL: {
                v = this.newNullSymbol();
                break;
            }
            case STRING: {
                v = this.newNullString();
                break;
            }
            case CLOB: {
                v = this.newNullClob();
                break;
            }
            case BLOB: {
                v = this.newNullBlob();
                break;
            }
            case LIST: {
                v = this.newEmptyList();
                break;
            }
            case SEXP: {
                v = this.newEmptySexp();
                break;
            }
            case STRUCT: {
                v = this.newEmptyStruct();
                break;
            }
            default: {
                throw new ionIonException("unexpected type encountered reading value: " + (Object)((Object)valueType));
            }
        }
        return v;
    }

    @Override
    public ionIonWriter newWriter(ionIonContainer container) {
        ionIonWriter writer = PrivateIonWriterFactory.makeWriter(container);
        return writer;
    }

    private ionIonValue singleValue(Iterator<ionIonValue> it) {
        ionIonValue value;
        try {
            value = it.next();
        }
        catch (NoSuchElementException e) {
            throw new ionUnexpectedEofException("no value found on input stream");
        }
        if (it.hasNext()) {
            throw new ionIonException("not a single value");
        }
        return value;
    }

    @Override
    public ionIonValue singleValue(String ionText) {
        Iterator<ionIonValue> it = this.iterate(ionText);
        return this.singleValue(it);
    }

    @Override
    public ionIonValue singleValue(byte[] ionData) {
        Iterator<ionIonValue> it = this.iterate(ionData);
        return this.singleValue(it);
    }

    protected IonSymbolLite newSystemIdSymbol(String ionVersionMarker) {
        if (!"$ion_1_0".equals(ionVersionMarker)) {
            throw new IllegalArgumentException("name isn't an ion version marker");
        }
        IonSymbolLite ivm = this.newSymbol(ionVersionMarker);
        ivm.setIsIonVersionMarker(true);
        return ivm;
    }

    @Override
    public ionIonTimestamp newUtcTimestampFromMillis(long millis) {
        IonTimestampLite result = this.newNullTimestamp();
        result.setMillisUtc(millis);
        return result;
    }

    @Override
    public ionIonTimestamp newUtcTimestamp(Date utcDate) {
        IonTimestampLite result = this.newNullTimestamp();
        if (utcDate != null) {
            result.setMillisUtc(utcDate.getTime());
        }
        return result;
    }

    @Override
    public ionIonTimestamp newCurrentUtcTimestamp() {
        IonTimestampLite result = super.newNullTimestamp();
        result.setCurrentTimeUtc();
        return result;
    }

    @Override
    public ionIonDatagram newDatagram() {
        ionIonCatalog catalog = this.getCatalog();
        IonDatagramLite dg = this.newDatagram(catalog);
        return dg;
    }

    public IonDatagramLite newDatagram(ionIonCatalog catalog) {
        if (catalog == null) {
            catalog = this.getCatalog();
        }
        IonDatagramLite dg = new IonDatagramLite(this, catalog);
        return dg;
    }

    @Override
    public ionIonDatagram newDatagram(ionIonValue initialChild) {
        ionIonDatagram dg = this.newDatagram(null, initialChild);
        return dg;
    }

    public ionIonDatagram newDatagram(ionIonCatalog catalog, ionIonValue initialChild) {
        IonDatagramLite dg = this.newDatagram(catalog);
        if (initialChild != null) {
            if (initialChild.getSystem() != this) {
                throw new ionIonException("this Ion system can't mix with instances from other system impl's");
            }
            if (initialChild.getContainer() != null) {
                initialChild = this.clone(initialChild);
            }
            dg.add(initialChild);
        }
        assert (dg.getSystem() == this);
        return dg;
    }

    @Override
    public ionIonDatagram newDatagram(ionSymbolTable ... imports) {
        ionIonDatagram dg = this.newDatagram((ionIonCatalog)null, imports);
        return dg;
    }

    public ionIonDatagram newDatagram(ionIonCatalog catalog, ionSymbolTable ... imports) {
        ionSymbolTable defaultSystemSymtab = this.getSystemSymbolTable();
        ionSymbolTable symbols = PrivateUtils.initialSymtab(this, defaultSystemSymtab, imports);
        IonDatagramLite dg = this.newDatagram(catalog);
        dg.appendTrailingSymbolTable(symbols);
        return dg;
    }

    @Override
    public ionIonReader newReader(byte[] ionData) {
        return PrivateIonReaderFactory.makeReader((ionIonSystem)this, this._catalog, ionData);
    }

    @Override
    public ionIonReader newSystemReader(byte[] ionData) {
        return PrivateIonReaderFactory.makeSystemReader((ionIonSystem)this, ionData);
    }

    @Override
    public ionIonReader newReader(byte[] ionData, int offset, int len) {
        return PrivateIonReaderFactory.makeReader((ionIonSystem)this, this._catalog, ionData, offset, len);
    }

    @Override
    public ionIonReader newSystemReader(byte[] ionData, int offset, int len) {
        return PrivateIonReaderFactory.makeSystemReader((ionIonSystem)this, ionData, offset, len);
    }

    @Override
    public ionIonReader newReader(String ionText) {
        return PrivateIonReaderFactory.makeReader((ionIonSystem)this, this._catalog, ionText);
    }

    @Override
    public ionIonReader newSystemReader(String ionText) {
        return PrivateIonReaderFactory.makeSystemReader((ionIonSystem)this, ionText);
    }

    @Override
    public ionIonReader newReader(InputStream ionData) {
        return PrivateIonReaderFactory.makeReader((ionIonSystem)this, this._catalog, ionData);
    }

    @Override
    public ionIonReader newSystemReader(InputStream ionData) {
        return PrivateIonReaderFactory.makeSystemReader((ionIonSystem)this, ionData);
    }

    @Override
    public ionIonReader newReader(Reader ionText) {
        return PrivateIonReaderFactory.makeReader((ionIonSystem)this, this._catalog, ionText);
    }

    @Override
    public ionIonReader newReader(ionIonValue value) {
        return PrivateIonReaderFactory.makeReader((ionIonSystem)this, this._catalog, value);
    }

    @Override
    public ionIonReader newSystemReader(Reader ionText) {
        return PrivateIonReaderFactory.makeSystemReader((ionIonSystem)this, ionText);
    }

    @Override
    public ionIonReader newSystemReader(ionIonValue value) {
        return PrivateIonReaderFactory.makeSystemReader((ionIonSystem)this, value);
    }

    @Override
    public ionIonWriter newTreeSystemWriter(ionIonContainer container) {
        ionIonWriter writer = PrivateIonWriterFactory.makeSystemWriter(container);
        return writer;
    }

    @Override
    public ionIonWriter newTreeWriter(ionIonContainer container) {
        ionIonWriter writer = PrivateIonWriterFactory.makeWriter(container);
        return writer;
    }

    @Override
    public Iterator<ionIonValue> systemIterate(Reader ionText) {
        ionIonReader ir = this.newSystemReader(ionText);
        return PrivateUtils.iterate(this, ir);
    }

    @Override
    public Iterator<ionIonValue> systemIterate(String ionText) {
        ionIonReader ir = this.newSystemReader(ionText);
        return PrivateUtils.iterate(this, ir);
    }

    @Override
    public Iterator<ionIonValue> systemIterate(InputStream ionData) {
        ionIonReader ir = this.newSystemReader(ionData);
        return PrivateUtils.iterate(this, ir);
    }

    @Override
    public Iterator<ionIonValue> systemIterate(byte[] ionData) {
        ionIonReader ir = this.newSystemReader(ionData);
        return PrivateUtils.iterate(this, ir);
    }

    @Override
    public boolean valueIsSharedSymbolTable(ionIonValue value) {
        return value instanceof ionIonStruct && value.hasTypeAnnotation("$ion_symbol_table");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReaderIterator
    implements Iterator<ionIonValue>,
    Closeable {
        private final ionIonReader _reader;
        private final IonSystemLite _system;
        private ionIonType _next;

        protected ReaderIterator(IonSystemLite system, ionIonReader reader) {
            this._reader = reader;
            this._system = system;
        }

        @Override
        public boolean hasNext() {
            if (this._next == null) {
                this._next = this._reader.next();
            }
            return this._next != null;
        }

        @Override
        public ionIonValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ionSymbolTable symtab = this._reader.getSymbolTable();
            IonValueLite value = this._system.newValue(this._reader);
            this._next = null;
            value.setSymbolTable(symtab);
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

