/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.lite;

import alluxio.shaded.client.software.amazon.ionIonBool;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonWriter;
import alluxio.shaded.client.software.amazon.ionNullValueException;
import alluxio.shaded.client.software.amazon.ionValueVisitor;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonValue;
import alluxio.shaded.client.software.amazon.ionimpl.lite.ContainerlessContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonValueLite;
import java.io.IOException;

final class IonBoolLite
extends IonValueLite
implements ionIonBool {
    private static final int HASH_SIGNATURE = ionIonType.BOOL.toString().hashCode();
    protected static final int TRUE_HASH = HASH_SIGNATURE ^ 16777619 * Boolean.TRUE.hashCode();
    protected static final int FALSE_HASH = HASH_SIGNATURE ^ 16777619 * Boolean.FALSE.hashCode();

    IonBoolLite(ContainerlessContext context, boolean isNull) {
        super(context, isNull);
    }

    IonBoolLite(IonBoolLite existing, IonContext context) {
        super(existing, context);
    }

    IonBoolLite clone(IonContext context) {
        return new IonBoolLite(this, context);
    }

    public IonBoolLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    public ionIonType getType() {
        return ionIonType.BOOL;
    }

    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int result = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            result = this.booleanValue() ? TRUE_HASH : FALSE_HASH;
        }
        return this.hashTypeAnnotations(result, symbolTableProvider);
    }

    public boolean booleanValue() throws ionNullValueException {
        this.validateThisNotNull();
        return this._isBoolTrue();
    }

    public void setValue(boolean b) {
        this.setValue((Boolean)b);
    }

    public void setValue(Boolean b) {
        this.checkForLock();
        if (b == null) {
            this._isBoolTrue(false);
            this._isNullValue(true);
        } else {
            this._isBoolTrue(b);
            this._isNullValue(false);
        }
    }

    final void writeBodyTo(ionIonWriter writer, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        if (this.isNullValue()) {
            writer.writeNull(ionIonType.BOOL);
        } else {
            writer.writeBool(this._isBoolTrue());
        }
    }

    public void accept(ionValueVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

