/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl;

import alluxio.shaded.client.software.amazon.ionIonLob;
import alluxio.shaded.client.software.amazon.ionIonReader;
import alluxio.shaded.client.software.amazon.ionIonSequence;
import alluxio.shaded.client.software.amazon.ionIonStruct;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonValue;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionSymbolToken;
import alluxio.shaded.client.software.amazon.ionValueFactory;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonValue;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IonIteratorImpl
implements Iterator<ionIonValue> {
    private final ionValueFactory _valueFactory;
    private final ionIonReader _reader;
    private boolean _at_eof;
    private ionIonValue _curr;
    private ionIonValue _next;

    public IonIteratorImpl(ionValueFactory valueFactory, ionIonReader input) {
        if (valueFactory == null || input == null) {
            throw new NullPointerException();
        }
        this._valueFactory = valueFactory;
        this._reader = input;
    }

    @Override
    public boolean hasNext() {
        if (this._at_eof) {
            return false;
        }
        if (this._next != null) {
            return true;
        }
        return this.prefetch() != null;
    }

    private ionIonValue prefetch() {
        assert (!this._at_eof && this._next == null);
        ionIonType type = this._reader.next();
        if (type == null) {
            this._at_eof = true;
        } else {
            this._next = this.readValue();
        }
        return this._next;
    }

    private ionIonValue readValue() {
        ionIonValue v;
        ionIonType type = this._reader.getType();
        ionSymbolToken[] annotations = this._reader.getTypeAnnotationSymbols();
        if (this._reader.isNullValue()) {
            v = this._valueFactory.newNull(type);
        } else {
            switch (type) {
                case NULL: {
                    throw new IllegalStateException();
                }
                case BOOL: {
                    v = this._valueFactory.newBool(this._reader.booleanValue());
                    break;
                }
                case INT: {
                    v = this._valueFactory.newInt(this._reader.bigIntegerValue());
                    break;
                }
                case FLOAT: {
                    v = this._valueFactory.newFloat(this._reader.doubleValue());
                    break;
                }
                case DECIMAL: {
                    v = this._valueFactory.newDecimal(this._reader.decimalValue());
                    break;
                }
                case TIMESTAMP: {
                    v = this._valueFactory.newTimestamp(this._reader.timestampValue());
                    break;
                }
                case STRING: {
                    v = this._valueFactory.newString(this._reader.stringValue());
                    break;
                }
                case SYMBOL: {
                    v = this._valueFactory.newSymbol(this._reader.symbolValue());
                    break;
                }
                case BLOB: {
                    ionIonLob lob = this._valueFactory.newNullBlob();
                    lob.setBytes(this._reader.newBytes());
                    v = lob;
                    break;
                }
                case CLOB: {
                    ionIonLob lob = this._valueFactory.newNullClob();
                    lob.setBytes(this._reader.newBytes());
                    v = lob;
                    break;
                }
                case STRUCT: {
                    ionIonStruct struct = this._valueFactory.newEmptyStruct();
                    this._reader.stepIn();
                    while (this._reader.next() != null) {
                        ionSymbolToken name = this._reader.getFieldNameSymbol();
                        ionIonValue child = this.readValue();
                        struct.add(name, child);
                    }
                    this._reader.stepOut();
                    v = struct;
                    break;
                }
                case LIST: {
                    ionIonSequence seq = this._valueFactory.newEmptyList();
                    this._reader.stepIn();
                    while (this._reader.next() != null) {
                        ionIonValue child = this.readValue();
                        seq.add(child);
                    }
                    this._reader.stepOut();
                    v = seq;
                    break;
                }
                case SEXP: {
                    ionIonSequence seq = this._valueFactory.newEmptySexp();
                    this._reader.stepIn();
                    while (this._reader.next() != null) {
                        ionIonValue child = this.readValue();
                        seq.add(child);
                    }
                    this._reader.stepOut();
                    v = seq;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        ionSymbolTable symtab = this._reader.getSymbolTable();
        ((PrivateIonValue)v).setSymbolTable(symtab);
        if (annotations.length != 0) {
            ((PrivateIonValue)v).setTypeAnnotationSymbols(annotations);
        }
        return v;
    }

    @Override
    public ionIonValue next() {
        if (!this._at_eof) {
            this._curr = null;
            if (this._next == null) {
                this.prefetch();
            }
            if (this._next != null) {
                this._curr = this._next;
                this._next = null;
                return this._curr;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

