/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.services;

import alluxio.shaded.client.io.grpc.BindableService;
import alluxio.shaded.client.io.grpc.ExperimentalApi;
import alluxio.shaded.client.io.grpc.ServerServiceDefinition;
import alluxio.shaded.client.io.grpc.services.ChannelzService;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7929")
@ThreadSafe
public final class AdminInterface {
    private static final int DEFAULT_CHANNELZ_MAX_PAGE_SIZE = 100;
    private static final Logger logger = Logger.getLogger(AdminInterface.class.getName());

    private AdminInterface() {
    }

    public static List<ServerServiceDefinition> getStandardServices() {
        ArrayList<ServerServiceDefinition> services = new ArrayList<ServerServiceDefinition>();
        services.add(ChannelzService.newInstance(100).bindService());
        BindableService csds = null;
        try {
            Class<?> clazz = Class.forName("alluxio.shaded.client.io.grpc.xds.CsdsService");
            Method m3 = clazz.getMethod("newInstance", new Class[0]);
            csds = (BindableService)m3.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Unable to find CSDS service", e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.FINE, "Unable to load CSDS service", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.FINE, "Unable to load CSDS service", e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.FINE, "Unable to load CSDS service", e);
        }
        if (csds != null) {
            services.add(csds.bindService());
        }
        return Collections.unmodifiableList(services);
    }
}

