/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.http.apache.client.impl;

import alluxio.shaded.client.com.amazonaws.http.AmazonHttpClient;
import alluxio.shaded.client.com.amazonaws.http.IdleConnectionReaper;
import alluxio.shaded.client.com.amazonaws.http.apache.SdkProxyRoutePlanner;
import alluxio.shaded.client.com.amazonaws.http.apache.client.impl.ApacheConnectionManagerFactory;
import alluxio.shaded.client.com.amazonaws.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import alluxio.shaded.client.com.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import alluxio.shaded.client.com.amazonaws.http.apache.client.impl.SdkHttpClient;
import alluxio.shaded.client.com.amazonaws.http.apache.utils.ApacheUtils;
import alluxio.shaded.client.com.amazonaws.http.client.ConnectionManagerFactory;
import alluxio.shaded.client.com.amazonaws.http.client.HttpClientFactory;
import alluxio.shaded.client.com.amazonaws.http.conn.ClientConnectionManagerFactory;
import alluxio.shaded.client.com.amazonaws.http.conn.SdkConnectionKeepAliveStrategy;
import alluxio.shaded.client.com.amazonaws.http.protocol.SdkHttpRequestExecutor;
import alluxio.shaded.client.com.amazonaws.http.settings.HttpClientSettings;
import alluxio.shaded.client.org.apache.http.conn.ConnectionKeepAliveStrategy;
import alluxio.shaded.client.org.apache.http.conn.HttpClientConnectionManager;
import alluxio.shaded.client.org.apache.http.impl.client.HttpClientBuilder;
import alluxio.shaded.client.org.apache.http.impl.client.HttpClients;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings settings) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(settings);
        builder.setRequestExecutor(new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(settings)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        if (!settings.useGzip()) {
            builder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor itcp = new CRC32ChecksumResponseInterceptor();
        if (settings.calculateCRC32FromCompressedData()) {
            builder.addInterceptorFirst(itcp);
        } else {
            builder.addInterceptorLast(itcp);
        }
        this.addProxyConfig(builder, settings);
        SdkHttpClient httpClient = new SdkHttpClient(builder.build(), cm);
        if (settings.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(cm, settings.getMaxIdleConnectionTime());
        }
        return httpClient;
    }

    private void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings) {
        if (settings.isProxyEnabled()) {
            LOG.info((Object)("Configuring Proxy. Proxy Host: " + settings.getProxyHost() + " Proxy Port: " + settings.getProxyPort()));
            builder.setRoutePlanner(new SdkProxyRoutePlanner(settings.getProxyHost(), settings.getProxyPort(), settings.getProxyProtocol(), settings.getNonProxyHosts()));
            if (settings.isAuthenticatedProxy()) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings settings) {
        return settings.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(settings.getMaxIdleConnectionTime()) : null;
    }
}

