/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.RuntimeConstants;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ClientCall;
import alluxio.shaded.client.io.grpc.ClientInterceptor;
import alluxio.shaded.client.io.grpc.ForwardingClientCall;
import alluxio.shaded.client.io.grpc.ForwardingClientCallListener;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.MethodDescriptor;

public class ClientVersionClientInjector
implements ClientInterceptor {
    public static final Metadata.Key<String> S_CLIENT_VERSION_KEY = Metadata.Key.of("alluxio-version", Metadata.ASCII_STRING_MARSHALLER);

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(S_CLIENT_VERSION_KEY, RuntimeConstants.VERSION_AND_REVISION_SHORT);
                super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                    }
                }, headers);
            }
        };
    }
}

