/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.file.options.UfsFileSystemOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.util.Optional;

public class FileSystemOptions {
    private final boolean mMetadataCacheEnabled;
    private final boolean mDataCacheEnabled;
    private final Optional<UfsFileSystemOptions> mUfsFileSystemOptions;

    public static FileSystemOptions create(AlluxioConfiguration conf) {
        return FileSystemOptions.create(conf, Optional.empty());
    }

    public static FileSystemOptions create(AlluxioConfiguration conf, Optional<UfsFileSystemOptions> ufsOptions) {
        return new FileSystemOptions(conf.getBoolean(PropertyKey.USER_METADATA_CACHE_ENABLED), conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_ENABLED), ufsOptions);
    }

    private FileSystemOptions(boolean metadataCacheEnabled, boolean dataCacheEnabled, Optional<UfsFileSystemOptions> ufsFileSystemOptions) {
        this.mUfsFileSystemOptions = Preconditions.checkNotNull(ufsFileSystemOptions);
        this.mMetadataCacheEnabled = metadataCacheEnabled;
        this.mDataCacheEnabled = dataCacheEnabled;
    }

    public Optional<UfsFileSystemOptions> getUfsFileSystemOptions() {
        return this.mUfsFileSystemOptions;
    }

    public boolean isMetadataCacheEnabled() {
        return this.mMetadataCacheEnabled;
    }

    public boolean isDataCacheEnabled() {
        return this.mDataCacheEnabled;
    }
}

