/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.simple;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.hive.formats.encodings.text.TextColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.TextEncodingOptions;
import io.trino.hive.formats.line.Column;
import io.trino.hive.formats.line.LineSerializer;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.List;

public class SimpleSerializer
implements LineSerializer {
    private final List<Column> columns;
    private final TextColumnEncoding[] columnEncodings;
    private final byte separator;
    private final Slice nullSequence;

    public SimpleSerializer(List<Column> columns, TextEncodingOptions options) {
        Preconditions.checkArgument(((long)columns.size() == columns.stream().mapToInt(Column::ordinal).distinct().count() ? 1 : 0) != 0, (String)"Columns cannot have duplicate ordinals: %s", columns);
        this.columns = ImmutableList.copyOf(columns);
        TextColumnEncodingFactory columnEncodingFactory = new TextColumnEncodingFactory(options);
        this.columnEncodings = (TextColumnEncoding[])columns.stream().map(column -> columnEncodingFactory.getEncoding(column.type())).toArray(TextColumnEncoding[]::new);
        this.separator = options.getSeparators().getByte(0);
        this.nullSequence = options.getNullSequence();
    }

    @Override
    public List<? extends Type> getTypes() {
        return (List)this.columns.stream().map(Column::type).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void write(Page page, int position, SliceOutput sliceOutput) throws IOException {
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            Block block;
            if (channel > 0) {
                sliceOutput.appendByte((int)this.separator);
            }
            if ((block = page.getBlock(channel)).isNull(position)) {
                sliceOutput.appendBytes(this.nullSequence);
                continue;
            }
            this.columnEncodings[channel].encodeValueInto(block, position, sliceOutput);
        }
    }
}

