/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import io.airlift.http.server.DelimitedRequestLog;
import io.airlift.http.server.DoubleSummaryStats;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;

public class HttpServerChannelListener
implements HttpChannel.Listener {
    private static final String REQUEST_BEGIN_ATTRIBUTE = HttpServerChannelListener.class.getName() + ".begin";
    private static final String REQUEST_BEGIN_TO_DISPATCH_ATTRIBUTE = HttpServerChannelListener.class.getName() + ".begin_to_dispatch";
    private static final String REQUEST_BEGIN_TO_END_ATTRIBUTE = HttpServerChannelListener.class.getName() + ".begin_to_end";
    private static final String RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE = HttpServerChannelListener.class.getName() + ".response_content_timestamps";
    private final DelimitedRequestLog logger;

    public HttpServerChannelListener(DelimitedRequestLog logger) {
        this.logger = Objects.requireNonNull(logger, "logger is null");
    }

    public void onRequestBegin(Request request) {
        request.setAttribute(REQUEST_BEGIN_ATTRIBUTE, (Object)System.nanoTime());
    }

    public void onBeforeDispatch(Request request) {
        long requestBeginTime = (Long)request.getAttribute(REQUEST_BEGIN_ATTRIBUTE);
        request.setAttribute(REQUEST_BEGIN_TO_DISPATCH_ATTRIBUTE, (Object)(System.nanoTime() - requestBeginTime));
    }

    public void onRequestEnd(Request request) {
        long requestBeginTime = (Long)request.getAttribute(REQUEST_BEGIN_ATTRIBUTE);
        request.setAttribute(REQUEST_BEGIN_TO_END_ATTRIBUTE, (Object)(System.nanoTime() - requestBeginTime));
    }

    public void onResponseBegin(Request request) {
        if (request.getAttribute(REQUEST_BEGIN_TO_END_ATTRIBUTE) == null) {
            this.onRequestEnd(request);
        }
        request.setAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE, new ArrayList());
    }

    public void onResponseContent(Request request, ByteBuffer content) {
        List contentTimestamps = (List)request.getAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE);
        contentTimestamps.add(System.nanoTime());
    }

    public void onComplete(Request request) {
        List contentTimestamps = (List)request.getAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE);
        long firstToLastContentTimeInMillis = -1L;
        if (contentTimestamps.size() > 0) {
            firstToLastContentTimeInMillis = TimeUnit.NANOSECONDS.toMillis((Long)contentTimestamps.get(contentTimestamps.size() - 1) - (Long)contentTimestamps.get(0));
        }
        long beginToDispatchMillis = TimeUnit.NANOSECONDS.toMillis((Long)request.getAttribute(REQUEST_BEGIN_TO_DISPATCH_ATTRIBUTE));
        long beginToEndMillis = TimeUnit.NANOSECONDS.toMillis((Long)request.getAttribute(REQUEST_BEGIN_TO_END_ATTRIBUTE));
        this.logger.log(request, request.getResponse(), beginToDispatchMillis, beginToEndMillis, firstToLastContentTimeInMillis, HttpServerChannelListener.processContentTimestamps(contentTimestamps));
    }

    @Nullable
    private static DoubleSummaryStats processContentTimestamps(List<Long> contentTimestamps) {
        Objects.requireNonNull(contentTimestamps, "contentTimestamps is null");
        if (contentTimestamps.size() == 0 || contentTimestamps.size() == 1) {
            return null;
        }
        DoubleSummaryStatistics statistics = new DoubleSummaryStatistics();
        long previousTimestamp = contentTimestamps.get(0);
        for (int i = 1; i < contentTimestamps.size(); ++i) {
            long timestamp = contentTimestamps.get(i);
            statistics.accept(TimeUnit.NANOSECONDS.toMillis(timestamp - previousTimestamp));
            previousTimestamp = timestamp;
        }
        return new DoubleSummaryStats(statistics);
    }
}

