/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.io;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.accumulo.conf.AccumuloConfig;
import io.trino.plugin.accumulo.io.AccumuloRecordSet;
import io.trino.plugin.accumulo.model.AccumuloColumnHandle;
import io.trino.plugin.accumulo.model.AccumuloSplit;
import io.trino.plugin.accumulo.model.AccumuloTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.Connector;

public class AccumuloRecordSetProvider
implements ConnectorRecordSetProvider {
    private final Connector connector;
    private final String username;

    @Inject
    public AccumuloRecordSetProvider(Connector connector, AccumuloConfig config) {
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.username = config.getUsername();
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        AccumuloSplit accSplit = (AccumuloSplit)split;
        AccumuloTableHandle accTable = (AccumuloTableHandle)table;
        List accColumns = (List)columns.stream().map(AccumuloColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        return new AccumuloRecordSet(this.connector, session, accSplit, this.username, accTable, accColumns);
    }
}

