/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import com.google.common.collect.ImmutableMap;
import io.airlift.stats.TimeStat;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HadoopPaths;
import io.trino.filesystem.hdfs.HdfsFileIterator;
import io.trino.filesystem.hdfs.HdfsInputFile;
import io.trino.filesystem.hdfs.HdfsOutputFile;
import io.trino.hdfs.FileSystemUtils;
import io.trino.hdfs.FileSystemWithBatchDelete;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.TrinoHdfsFileSystemStats;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

class HdfsFileSystem
implements TrinoFileSystem {
    private static final Map<String, Boolean> KNOWN_HIERARCHICAL_FILESYSTEMS = ImmutableMap.builder().put((Object)"s3", (Object)false).put((Object)"s3a", (Object)false).put((Object)"s3n", (Object)false).put((Object)"hdfs", (Object)true).buildOrThrow();
    private final HdfsEnvironment environment;
    private final HdfsContext context;
    private final TrinoHdfsFileSystemStats stats;
    private final Map<FileSystem, Boolean> hierarchicalFileSystemCache = new IdentityHashMap<FileSystem, Boolean>();

    public HdfsFileSystem(HdfsEnvironment environment, HdfsContext context, TrinoHdfsFileSystemStats stats) {
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public TrinoInputFile newInputFile(Location location) {
        return new HdfsInputFile(location, null, this.environment, this.context, this.stats.getOpenFileCalls());
    }

    public TrinoInputFile newInputFile(Location location, long length) {
        return new HdfsInputFile(location, length, this.environment, this.context, this.stats.getOpenFileCalls());
    }

    public TrinoOutputFile newOutputFile(Location location) {
        return new HdfsOutputFile(location, this.environment, this.context, this.stats.getCreateFileCalls());
    }

    public void deleteFile(Location location) throws IOException {
        this.stats.getDeleteFileCalls().newCall();
        Path file = HadoopPaths.hadoopPath(location);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, file);
        this.environment.doAs(this.context.getIdentity(), () -> {
            Object var4_5;
            block9: {
                TimeStat.BlockTimer ignored = this.stats.getDeleteFileCalls().time();
                try {
                    if (!fileSystem.delete(file, false)) {
                        throw new IOException("Failed to delete file: " + file);
                    }
                    var4_5 = null;
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.stats.getDeleteFileCalls().recordException(e);
                        throw e;
                    }
                }
                ignored.close();
            }
            return var4_5;
        });
    }

    public void deleteFiles(Collection<Location> locations) throws IOException {
        Map pathsGroupedByDirectory = locations.stream().collect(Collectors.groupingBy(location -> HadoopPaths.hadoopPath(location.parentDirectory()), Collectors.mapping(HadoopPaths::hadoopPath, Collectors.toList())));
        for (Map.Entry directoryWithPaths : pathsGroupedByDirectory.entrySet()) {
            FileSystem rawFileSystem = FileSystemUtils.getRawFileSystem(this.environment.getFileSystem(this.context, directoryWithPaths.getKey()));
            this.environment.doAs(this.context.getIdentity(), () -> {
                if (rawFileSystem instanceof FileSystemWithBatchDelete) {
                    FileSystemWithBatchDelete fileSystemWithBatchDelete = (FileSystemWithBatchDelete)rawFileSystem;
                    fileSystemWithBatchDelete.deleteFiles((Collection)directoryWithPaths.getValue());
                } else {
                    for (Path path : (List)directoryWithPaths.getValue()) {
                        this.stats.getDeleteFileCalls().newCall();
                        try {
                            TimeStat.BlockTimer ignored = this.stats.getDeleteFileCalls().time();
                            try {
                                rawFileSystem.delete(path, false);
                            }
                            finally {
                                if (ignored == null) continue;
                                ignored.close();
                            }
                        }
                        catch (IOException e) {
                            this.stats.getDeleteFileCalls().recordException(e);
                            throw e;
                        }
                    }
                }
                return null;
            });
        }
    }

    public void deleteDirectory(Location location) throws IOException {
        this.stats.getDeleteDirectoryCalls().newCall();
        Path directory = HadoopPaths.hadoopPath(location);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, directory);
        this.environment.doAs(this.context.getIdentity(), () -> {
            Object var4_5;
            block9: {
                TimeStat.BlockTimer ignored = this.stats.getDeleteDirectoryCalls().time();
                try {
                    if (!fileSystem.delete(directory, true) && fileSystem.exists(directory)) {
                        throw new IOException("Failed to delete directory: " + directory);
                    }
                    var4_5 = null;
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.stats.getDeleteDirectoryCalls().recordException(e);
                        throw e;
                    }
                }
                ignored.close();
            }
            return var4_5;
        });
    }

    public void renameFile(Location source, Location target) throws IOException {
        this.stats.getRenameFileCalls().newCall();
        Path sourcePath = HadoopPaths.hadoopPath(source);
        Path targetPath = HadoopPaths.hadoopPath(target);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, sourcePath);
        this.environment.doAs(this.context.getIdentity(), () -> {
            Object var7_8;
            block9: {
                TimeStat.BlockTimer ignored = this.stats.getRenameFileCalls().time();
                try {
                    if (!fileSystem.rename(sourcePath, targetPath)) {
                        throw new IOException(String.format("Failed to rename [%s] to [%s]", source, target));
                    }
                    var7_8 = null;
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.stats.getRenameFileCalls().recordException(e);
                        throw e;
                    }
                }
                ignored.close();
            }
            return var7_8;
        });
    }

    public FileIterator listFiles(Location location) throws IOException {
        this.stats.getListFilesCalls().newCall();
        Path directory = HadoopPaths.hadoopPath(location);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, directory);
        return this.environment.doAs(this.context.getIdentity(), () -> {
            HdfsFileIterator hdfsFileIterator;
            block9: {
                TimeStat.BlockTimer ignored = this.stats.getListFilesCalls().time();
                try {
                    hdfsFileIterator = new HdfsFileIterator(location, directory, (RemoteIterator<LocatedFileStatus>)fileSystem.listFiles(directory, true));
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.stats.getListFilesCalls().recordException(e);
                        if (e instanceof FileNotFoundException) {
                            return FileIterator.empty();
                        }
                        throw e;
                    }
                }
                ignored.close();
            }
            return hdfsFileIterator;
        });
    }

    public Optional<Boolean> directoryExists(Location location) throws IOException {
        this.stats.getDirectoryExistsCalls().newCall();
        Path directory = HadoopPaths.hadoopPath(location);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, directory);
        return this.environment.doAs(this.context.getIdentity(), () -> {
            Optional<Boolean> optional;
            block10: {
                if (!this.hierarchical(fileSystem, location)) {
                    return Optional.empty();
                }
                TimeStat.BlockTimer ignored = this.stats.getDirectoryExistsCalls().time();
                try {
                    FileStatus fileStatus = fileSystem.getFileStatus(directory);
                    optional = Optional.of(fileStatus.isDirectory());
                    if (ignored == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        return Optional.of(false);
                    }
                    catch (IOException e) {
                        this.stats.getListFilesCalls().recordException(e);
                        throw e;
                    }
                }
                ignored.close();
            }
            return optional;
        });
    }

    private boolean hierarchical(FileSystem fileSystem, Location rootLocation) {
        Boolean knownResult = KNOWN_HIERARCHICAL_FILESYSTEMS.get(fileSystem.getScheme());
        if (knownResult != null) {
            return knownResult;
        }
        Boolean cachedResult = this.hierarchicalFileSystemCache.get(fileSystem);
        if (cachedResult != null) {
            return cachedResult;
        }
        try {
            fileSystem.listStatus(HadoopPaths.hadoopPath(rootLocation.appendPath(UUID.randomUUID().toString())));
            this.hierarchicalFileSystemCache.putIfAbsent(fileSystem, false);
            return false;
        }
        catch (IOException e) {
            this.hierarchicalFileSystemCache.putIfAbsent(fileSystem, true);
            return true;
        }
    }
}

