/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class TextHeaderWriter {
    private final Serializer serializer;
    private final Type headerType;
    private final List<String> fileColumnNames;

    public TextHeaderWriter(Serializer serializer, TypeManager typeManager, ConnectorSession session, List<String> fileColumnNames) {
        this.serializer = serializer;
        this.fileColumnNames = fileColumnNames;
        this.headerType = HiveType.valueOf("string").getType(typeManager, HiveSessionProperties.getTimestampPrecision(session));
    }

    public void write(OutputStream compressedOutput, int rowSeparator) throws IOException {
        try {
            ObjectInspector stringObjectInspector = HiveWriteUtils.getRowColumnInspector(this.headerType);
            List headers = (List)this.fileColumnNames.stream().map(Text::new).collect(ImmutableList.toImmutableList());
            List<ObjectInspector> inspectors = Collections.nCopies(this.fileColumnNames.size(), stringObjectInspector);
            StandardStructObjectInspector headerStructObjectInspectors = ObjectInspectorFactory.getStandardStructObjectInspector(this.fileColumnNames, inspectors);
            BinaryComparable binary = (BinaryComparable)this.serializer.serialize((Object)headers, (ObjectInspector)headerStructObjectInspectors);
            compressedOutput.write(binary.getBytes(), 0, binary.getLength());
            compressedOutput.write(rowSeparator);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
    }
}

