/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.orc.OrcDataSink;
import io.trino.orc.OrcWriteValidation;
import io.trino.orc.OrcWriter;
import io.trino.orc.OrcWriterOptions;
import io.trino.orc.OrcWriterStats;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcType;
import io.trino.spi.Page;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;

public class TempFileWriter
implements Closeable {
    private final OrcWriter orcWriter;

    public TempFileWriter(List<Type> types, OrcDataSink sink) {
        this.orcWriter = TempFileWriter.createOrcFileWriter(sink, types);
    }

    public void writePage(Page page) {
        try {
            this.orcWriter.write(page);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.orcWriter.close();
    }

    public long getWrittenBytes() {
        return this.orcWriter.getWrittenBytes();
    }

    private static OrcWriter createOrcFileWriter(OrcDataSink sink, List<Type> types) {
        List columnNames = (List)IntStream.range(0, types.size()).mapToObj(String::valueOf).collect(ImmutableList.toImmutableList());
        return new OrcWriter(sink, columnNames, types, OrcType.createRootOrcType((List)columnNames, types, Optional.of(type -> {
            if (type.equals(TimeType.TIME_MICROS)) {
                return Optional.of(new OrcType(OrcType.OrcTypeKind.LONG, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of((Object)"iceberg.long-type", (Object)"TIME")));
            }
            if (type.getBaseName().equals("uuid")) {
                return Optional.of(new OrcType(OrcType.OrcTypeKind.BINARY, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of((Object)"iceberg.binary-type", (Object)"UUID")));
            }
            return Optional.empty();
        })), CompressionKind.LZ4, new OrcWriterOptions().withMaxStringStatisticsLimit(DataSize.ofBytes((long)0L)).withStripeMinSize(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).withDictionaryMaxMemory(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), (Map)ImmutableMap.of(), false, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());
    }
}

