/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.metastore.BooleanStatistics;
import io.trino.plugin.hive.metastore.DateStatistics;
import io.trino.plugin.hive.metastore.DecimalStatistics;
import io.trino.plugin.hive.metastore.DoubleStatistics;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.IntegerStatistics;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;

public final class Statistics {
    private Statistics() {
    }

    public static PartitionStatistics merge(PartitionStatistics first, PartitionStatistics second) {
        if (first.getBasicStatistics().getRowCount().isPresent() && first.getBasicStatistics().getRowCount().getAsLong() == 0L) {
            return second;
        }
        if (second.getBasicStatistics().getRowCount().isPresent() && second.getBasicStatistics().getRowCount().getAsLong() == 0L) {
            return first;
        }
        return new PartitionStatistics(Statistics.reduce(first.getBasicStatistics(), second.getBasicStatistics(), ReduceOperator.ADD), Statistics.merge(first.getColumnStatistics(), second.getColumnStatistics()));
    }

    public static HiveBasicStatistics reduce(HiveBasicStatistics first, HiveBasicStatistics second, ReduceOperator operator) {
        return new HiveBasicStatistics(Statistics.reduce(first.getFileCount(), second.getFileCount(), operator, false), Statistics.reduce(first.getRowCount(), second.getRowCount(), operator, false), Statistics.reduce(first.getInMemoryDataSizeInBytes(), second.getInMemoryDataSizeInBytes(), operator, false), Statistics.reduce(first.getOnDiskDataSizeInBytes(), second.getOnDiskDataSizeInBytes(), operator, false));
    }

    public static Map<String, HiveColumnStatistics> merge(Map<String, HiveColumnStatistics> first, Map<String, HiveColumnStatistics> second) {
        Sets.SetView columns = Sets.intersection(first.keySet(), second.keySet());
        return (Map)columns.stream().collect(ImmutableMap.toImmutableMap(column -> column, column -> Statistics.merge((HiveColumnStatistics)first.get(column), (HiveColumnStatistics)second.get(column))));
    }

    public static HiveColumnStatistics merge(HiveColumnStatistics first, HiveColumnStatistics second) {
        return new HiveColumnStatistics(Statistics.mergeIntegerStatistics(first.getIntegerStatistics(), second.getIntegerStatistics()), Statistics.mergeDoubleStatistics(first.getDoubleStatistics(), second.getDoubleStatistics()), Statistics.mergeDecimalStatistics(first.getDecimalStatistics(), second.getDecimalStatistics()), Statistics.mergeDateStatistics(first.getDateStatistics(), second.getDateStatistics()), Statistics.mergeBooleanStatistics(first.getBooleanStatistics(), second.getBooleanStatistics()), Statistics.reduce(first.getMaxValueSizeInBytes(), second.getMaxValueSizeInBytes(), ReduceOperator.MAX, true), Statistics.reduce(first.getTotalSizeInBytes(), second.getTotalSizeInBytes(), ReduceOperator.ADD, true), Statistics.reduce(first.getNullsCount(), second.getNullsCount(), ReduceOperator.ADD, false), Statistics.reduce(first.getDistinctValuesCount(), second.getDistinctValuesCount(), ReduceOperator.MAX, false));
    }

    private static Optional<IntegerStatistics> mergeIntegerStatistics(Optional<IntegerStatistics> first, Optional<IntegerStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new IntegerStatistics(Statistics.reduce(first.get().getMin(), second.get().getMin(), ReduceOperator.MIN, true), Statistics.reduce(first.get().getMax(), second.get().getMax(), ReduceOperator.MAX, true)));
        }
        return Optional.empty();
    }

    private static Optional<DoubleStatistics> mergeDoubleStatistics(Optional<DoubleStatistics> first, Optional<DoubleStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new DoubleStatistics(Statistics.reduce(first.get().getMin(), second.get().getMin(), ReduceOperator.MIN, true), Statistics.reduce(first.get().getMax(), second.get().getMax(), ReduceOperator.MAX, true)));
        }
        return Optional.empty();
    }

    private static Optional<DecimalStatistics> mergeDecimalStatistics(Optional<DecimalStatistics> first, Optional<DecimalStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new DecimalStatistics(Statistics.reduce(first.get().getMin(), second.get().getMin(), ReduceOperator.MIN, true), Statistics.reduce(first.get().getMax(), second.get().getMax(), ReduceOperator.MAX, true)));
        }
        return Optional.empty();
    }

    private static Optional<DateStatistics> mergeDateStatistics(Optional<DateStatistics> first, Optional<DateStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new DateStatistics(Statistics.reduce(first.get().getMin(), second.get().getMin(), ReduceOperator.MIN, true), Statistics.reduce(first.get().getMax(), second.get().getMax(), ReduceOperator.MAX, true)));
        }
        return Optional.empty();
    }

    private static Optional<BooleanStatistics> mergeBooleanStatistics(Optional<BooleanStatistics> first, Optional<BooleanStatistics> second) {
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(new BooleanStatistics(Statistics.reduce(first.get().getTrueCount(), second.get().getTrueCount(), ReduceOperator.ADD, false), Statistics.reduce(first.get().getFalseCount(), second.get().getFalseCount(), ReduceOperator.ADD, false)));
        }
        return Optional.empty();
    }

    private static OptionalLong reduce(OptionalLong first, OptionalLong second, ReduceOperator operator, boolean returnFirstNonEmpty) {
        if (first.isPresent() && second.isPresent()) {
            switch (operator) {
                case ADD: {
                    return OptionalLong.of(first.getAsLong() + second.getAsLong());
                }
                case SUBTRACT: {
                    return OptionalLong.of(first.getAsLong() - second.getAsLong());
                }
                case MAX: {
                    return OptionalLong.of(Statistics.max(first.getAsLong(), second.getAsLong()));
                }
                case MIN: {
                    return OptionalLong.of(Statistics.min(first.getAsLong(), second.getAsLong()));
                }
            }
            throw new IllegalArgumentException("Unexpected operator: " + operator);
        }
        if (returnFirstNonEmpty) {
            return first.isPresent() ? first : second;
        }
        return OptionalLong.empty();
    }

    private static OptionalDouble reduce(OptionalDouble first, OptionalDouble second, ReduceOperator operator, boolean returnFirstNonEmpty) {
        if (first.isPresent() && second.isPresent()) {
            switch (operator) {
                case ADD: {
                    return OptionalDouble.of(first.getAsDouble() + second.getAsDouble());
                }
                case SUBTRACT: {
                    return OptionalDouble.of(first.getAsDouble() - second.getAsDouble());
                }
                case MAX: {
                    return OptionalDouble.of(Statistics.max(first.getAsDouble(), second.getAsDouble()));
                }
                case MIN: {
                    return OptionalDouble.of(Statistics.min(first.getAsDouble(), second.getAsDouble()));
                }
            }
            throw new IllegalArgumentException("Unexpected operator: " + operator);
        }
        if (returnFirstNonEmpty) {
            return first.isPresent() ? first : second;
        }
        return OptionalDouble.empty();
    }

    private static <T extends Comparable<? super T>> Optional<T> reduce(Optional<T> first, Optional<T> second, ReduceOperator operator, boolean returnFirstNonEmpty) {
        if (first.isPresent() && second.isPresent()) {
            switch (operator) {
                case ADD: 
                case SUBTRACT: {
                    break;
                }
                case MAX: {
                    return Optional.of(Statistics.max((Comparable)first.get(), (Comparable)second.get()));
                }
                case MIN: {
                    return Optional.of(Statistics.min((Comparable)first.get(), (Comparable)second.get()));
                }
            }
            throw new IllegalArgumentException("Unexpected operator: " + operator);
        }
        if (returnFirstNonEmpty) {
            return first.isPresent() ? first : second;
        }
        return Optional.empty();
    }

    private static <T extends Comparable<? super T>> T max(T first, T second) {
        return first.compareTo(second) >= 0 ? first : second;
    }

    private static <T extends Comparable<? super T>> T min(T first, T second) {
        return first.compareTo(second) <= 0 ? first : second;
    }

    public static PartitionStatistics createEmptyPartitionStatistics(Map<String, Type> columnTypes, Map<String, Set<HiveColumnStatisticType>> columnStatisticsMetadataTypes) {
        Map columnStatistics = (Map)columnStatisticsMetadataTypes.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Statistics.createColumnStatisticsForEmptyPartition((Type)columnTypes.get(entry.getKey()), (Set)entry.getValue())));
        return new PartitionStatistics(HiveBasicStatistics.createZeroStatistics(), columnStatistics);
    }

    private static HiveColumnStatistics createColumnStatisticsForEmptyPartition(Type columnType, Set<HiveColumnStatisticType> columnStatisticTypes) {
        Objects.requireNonNull(columnType, "columnType is null");
        HiveColumnStatistics.Builder result = HiveColumnStatistics.builder();
        for (HiveColumnStatisticType columnStatisticType : columnStatisticTypes) {
            Statistics.setColumnStatisticsForEmptyPartition(columnType, result, columnStatisticType);
        }
        return result.build();
    }

    private static void setColumnStatisticsForEmptyPartition(Type columnType, HiveColumnStatistics.Builder result, HiveColumnStatisticType columnStatisticType) {
        switch (columnStatisticType) {
            case MAX_VALUE_SIZE_IN_BYTES: {
                result.setMaxValueSizeInBytes(0L);
                return;
            }
            case TOTAL_SIZE_IN_BYTES: {
                result.setTotalSizeInBytes(0L);
                return;
            }
            case NUMBER_OF_DISTINCT_VALUES: {
                result.setDistinctValuesCount(0L);
                return;
            }
            case NUMBER_OF_NON_NULL_VALUES: {
                result.setNullsCount(0L);
                return;
            }
            case NUMBER_OF_TRUE_VALUES: {
                result.setBooleanStatistics(new BooleanStatistics(OptionalLong.of(0L), OptionalLong.of(0L)));
                return;
            }
            case MIN_VALUE: 
            case MAX_VALUE: {
                Statistics.setMinMaxForEmptyPartition(columnType, result);
                return;
            }
        }
        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_COLUMN_STATISTIC_TYPE, "Unknown column statistics type: " + columnStatisticType.name());
    }

    private static void setMinMaxForEmptyPartition(Type type, HiveColumnStatistics.Builder result) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            result.setIntegerStatistics(new IntegerStatistics(OptionalLong.empty(), OptionalLong.empty()));
        } else if (type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL)) {
            result.setDoubleStatistics(new DoubleStatistics(OptionalDouble.empty(), OptionalDouble.empty()));
        } else if (type.equals(DateType.DATE)) {
            result.setDateStatistics(new DateStatistics(Optional.empty(), Optional.empty()));
        } else if (type instanceof DecimalType) {
            result.setDecimalStatistics(new DecimalStatistics(Optional.empty(), Optional.empty()));
        } else {
            throw new IllegalArgumentException("Unexpected type: " + type);
        }
    }

    public static Map<List<String>, ComputedStatistics> createComputedStatisticsToPartitionMap(Collection<ComputedStatistics> computedStatistics, List<String> partitionColumns, Map<String, Type> columnTypes) {
        List partitionColumnTypes = (List)partitionColumns.stream().map(columnTypes::get).collect(ImmutableList.toImmutableList());
        return (Map)computedStatistics.stream().collect(ImmutableMap.toImmutableMap(statistics -> Statistics.getPartitionValues(statistics, partitionColumns, partitionColumnTypes), Function.identity()));
    }

    private static List<String> getPartitionValues(ComputedStatistics statistics, List<String> partitionColumns, List<Type> partitionColumnTypes) {
        Preconditions.checkArgument((boolean)statistics.getGroupingColumns().equals(partitionColumns), (String)"Unexpected grouping. Partition columns: %s. Grouping columns: %s", partitionColumns, (Object)statistics.getGroupingColumns());
        Page partitionColumnsPage = new Page(1, statistics.getGroupingValues().toArray(new Block[0]));
        return HiveWriteUtils.createPartitionValues(partitionColumnTypes, partitionColumnsPage, 0);
    }

    public static Map<String, HiveColumnStatistics> fromComputedStatistics(Map<ColumnStatisticMetadata, Block> computedStatistics, Map<String, Type> columnTypes, long rowCount) {
        return (Map)Statistics.createColumnToComputedStatisticsMap(computedStatistics).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Statistics.createHiveColumnStatistics((Map)entry.getValue(), (Type)columnTypes.get(entry.getKey()), rowCount)));
    }

    private static Map<String, Map<HiveColumnStatisticType, Block>> createColumnToComputedStatisticsMap(Map<ColumnStatisticMetadata, Block> computedStatistics) {
        HashMap result = new HashMap();
        computedStatistics.forEach((metadata, block) -> {
            Map columnStatistics = result.computeIfAbsent(metadata.getColumnName(), key -> new HashMap());
            columnStatistics.put(HiveColumnStatisticType.from(metadata), block);
        });
        return (Map)result.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
    }

    @VisibleForTesting
    static HiveColumnStatistics createHiveColumnStatistics(Map<HiveColumnStatisticType, Block> computedStatistics, Type columnType, long rowCount) {
        HiveColumnStatistics.Builder result = HiveColumnStatistics.builder();
        Verify.verify((computedStatistics.containsKey((Object)HiveColumnStatisticType.MIN_VALUE) == computedStatistics.containsKey((Object)HiveColumnStatisticType.MAX_VALUE) ? 1 : 0) != 0);
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.MIN_VALUE)) {
            Statistics.setMinMax(columnType, computedStatistics.get((Object)HiveColumnStatisticType.MIN_VALUE), computedStatistics.get((Object)HiveColumnStatisticType.MAX_VALUE), result);
        }
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES)) {
            result.setMaxValueSizeInBytes(Statistics.getIntegerValue((Type)BigintType.BIGINT, computedStatistics.get((Object)HiveColumnStatisticType.MAX_VALUE_SIZE_IN_BYTES)));
        }
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.TOTAL_SIZE_IN_BYTES)) {
            result.setTotalSizeInBytes(Statistics.getIntegerValue((Type)BigintType.BIGINT, computedStatistics.get((Object)HiveColumnStatisticType.TOTAL_SIZE_IN_BYTES)));
        }
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES)) {
            result.setNullsCount(rowCount - BigintType.BIGINT.getLong(computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), 0));
        }
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES) && computedStatistics.containsKey((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES)) {
            long numberOfNonNullValues = BigintType.BIGINT.getLong(computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), 0);
            long numberOfDistinctValues = BigintType.BIGINT.getLong(computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_DISTINCT_VALUES), 0);
            if (numberOfDistinctValues > numberOfNonNullValues) {
                result.setDistinctValuesCount(numberOfNonNullValues);
            } else {
                result.setDistinctValuesCount(numberOfDistinctValues);
            }
        }
        if (computedStatistics.containsKey((Object)HiveColumnStatisticType.NUMBER_OF_TRUE_VALUES) && computedStatistics.containsKey((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES)) {
            long numberOfTrue = BigintType.BIGINT.getLong(computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_TRUE_VALUES), 0);
            long numberOfNonNullValues = BigintType.BIGINT.getLong(computedStatistics.get((Object)HiveColumnStatisticType.NUMBER_OF_NON_NULL_VALUES), 0);
            result.setBooleanStatistics(new BooleanStatistics(OptionalLong.of(numberOfTrue), OptionalLong.of(numberOfNonNullValues - numberOfTrue)));
        }
        return result.build();
    }

    private static void setMinMax(Type type, Block min, Block max, HiveColumnStatistics.Builder result) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            result.setIntegerStatistics(new IntegerStatistics(Statistics.getIntegerValue(type, min), Statistics.getIntegerValue(type, max)));
        } else if (type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL)) {
            result.setDoubleStatistics(new DoubleStatistics(Statistics.getDoubleValue(type, min), Statistics.getDoubleValue(type, max)));
        } else if (type.equals(DateType.DATE)) {
            result.setDateStatistics(new DateStatistics(Statistics.getDateValue(type, min), Statistics.getDateValue(type, max)));
        } else if (type instanceof DecimalType) {
            result.setDecimalStatistics(new DecimalStatistics(Statistics.getDecimalValue(type, min), Statistics.getDecimalValue(type, max)));
        } else {
            throw new IllegalArgumentException("Unexpected type: " + type);
        }
    }

    private static OptionalLong getIntegerValue(Type type, Block block) {
        Verify.verify((type == BigintType.BIGINT || type == IntegerType.INTEGER || type == SmallintType.SMALLINT || type == TinyintType.TINYINT ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)type);
        if (block.isNull(0)) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(type.getLong(block, 0));
    }

    private static OptionalDouble getDoubleValue(Type type, Block block) {
        double value;
        Verify.verify((type == DoubleType.DOUBLE || type == RealType.REAL ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)type);
        if (block.isNull(0)) {
            return OptionalDouble.empty();
        }
        if (type == DoubleType.DOUBLE) {
            value = type.getDouble(block, 0);
        } else {
            Verify.verify((type == RealType.REAL ? 1 : 0) != 0);
            value = Float.intBitsToFloat(Math.toIntExact(type.getLong(block, 0)));
        }
        if (!Double.isFinite(value)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(value);
    }

    private static Optional<LocalDate> getDateValue(Type type, Block block) {
        Verify.verify((type == DateType.DATE ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)type);
        if (block.isNull(0)) {
            return Optional.empty();
        }
        int days = Math.toIntExact(type.getLong(block, 0));
        return Optional.of(LocalDate.ofEpochDay(days));
    }

    private static Optional<BigDecimal> getDecimalValue(Type type, Block block) {
        Verify.verify((boolean)(type instanceof DecimalType), (String)"Unsupported type: %s", (Object)type);
        if (block.isNull(0)) {
            return Optional.empty();
        }
        return Optional.of(Decimals.readBigDecimal((DecimalType)((DecimalType)type), (Block)block, (int)0));
    }

    public static enum ReduceOperator {
        ADD,
        SUBTRACT,
        MIN,
        MAX;

    }
}

