/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.reader.ParquetReader;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class ParquetPageSource
implements ConnectorPageSource {
    private final ParquetReader parquetReader;
    private final List<ColumnAdaptation> columnAdaptations;
    private final boolean isColumnAdaptationRequired;
    private boolean closed;
    private long completedPositions;

    private ParquetPageSource(ParquetReader parquetReader, List<ColumnAdaptation> columnAdaptations) {
        this.parquetReader = Objects.requireNonNull(parquetReader, "parquetReader is null");
        this.columnAdaptations = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnAdaptations, "columnAdaptations is null"));
        this.isColumnAdaptationRequired = ParquetPageSource.isColumnAdaptationRequired(columnAdaptations);
    }

    public long getCompletedBytes() {
        return this.parquetReader.getDataSource().getReadBytes();
    }

    public OptionalLong getCompletedPositions() {
        return OptionalLong.of(this.completedPositions);
    }

    public long getReadTimeNanos() {
        return this.parquetReader.getDataSource().getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public long getMemoryUsage() {
        return this.parquetReader.getMemoryContext().getBytes();
    }

    public Page getNextPage() {
        Page page;
        try {
            page = this.getColumnAdaptationsPage(this.parquetReader.nextPage());
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw ParquetPageSource.handleException(this.parquetReader.getDataSource().getId(), e);
        }
        if (this.closed || page == null) {
            this.close();
            return null;
        }
        this.completedPositions += (long)page.getPositionCount();
        return page;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Metrics getMetrics() {
        return this.parquetReader.getMetrics();
    }

    public static Builder builder() {
        return new Builder();
    }

    private Page getColumnAdaptationsPage(Page page) {
        if (!this.isColumnAdaptationRequired) {
            return page;
        }
        if (page == null) {
            return null;
        }
        int batchSize = page.getPositionCount();
        Block[] blocks = new Block[this.columnAdaptations.size()];
        long startRowId = this.parquetReader.lastBatchStartRow();
        for (int columnChannel = 0; columnChannel < this.columnAdaptations.size(); ++columnChannel) {
            blocks[columnChannel] = this.columnAdaptations.get(columnChannel).getBlock(page, startRowId);
        }
        return new Page(batchSize, blocks);
    }

    static TrinoException handleException(ParquetDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            return (TrinoException)((Object)exception);
        }
        if (exception instanceof ParquetCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read Parquet file: %s", dataSourceId), (Throwable)exception);
    }

    private static boolean isColumnAdaptationRequired(List<ColumnAdaptation> columnAdaptations) {
        for (int columnChannel = 0; columnChannel < columnAdaptations.size(); ++columnChannel) {
            ColumnAdaptation column = columnAdaptations.get(columnChannel);
            if (column instanceof SourceColumn) {
                int delegateChannel = ((SourceColumn)column).getSourceChannel();
                if (columnChannel == delegateChannel) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private static Block createRowNumberBlock(long baseIndex, int size) {
        long[] rowIndices = new long[size];
        for (int position = 0; position < size; ++position) {
            rowIndices[position] = baseIndex + (long)position;
        }
        return new LongArrayBlock(size, Optional.empty(), rowIndices);
    }

    public static class Builder {
        private final ImmutableList.Builder<ColumnAdaptation> columns = ImmutableList.builder();

        private Builder() {
        }

        public Builder addConstantColumn(Block value) {
            this.columns.add((Object)new ConstantColumn(value));
            return this;
        }

        public Builder addSourceColumn(int sourceChannel) {
            this.columns.add((Object)new SourceColumn(sourceChannel));
            return this;
        }

        public Builder addNullColumn(Type type) {
            this.columns.add((Object)new NullColumn(type));
            return this;
        }

        public Builder addRowIndexColumn() {
            this.columns.add((Object)new RowIndexColumn());
            return this;
        }

        public ConnectorPageSource build(ParquetReader parquetReader) {
            return new ParquetPageSource(parquetReader, (List<ColumnAdaptation>)this.columns.build());
        }
    }

    private static interface ColumnAdaptation {
        public Block getBlock(Page var1, long var2);
    }

    private static class SourceColumn
    implements ColumnAdaptation {
        private final int sourceChannel;

        private SourceColumn(int sourceChannel) {
            Preconditions.checkArgument((sourceChannel >= 0 ? 1 : 0) != 0, (Object)"sourceChannel is negative");
            this.sourceChannel = sourceChannel;
        }

        @Override
        public Block getBlock(Page sourcePage, long startRowId) {
            return sourcePage.getBlock(this.sourceChannel);
        }

        public int getSourceChannel() {
            return this.sourceChannel;
        }
    }

    private static class RowIndexColumn
    implements ColumnAdaptation {
        private RowIndexColumn() {
        }

        @Override
        public Block getBlock(Page sourcePage, long startRowId) {
            return ParquetPageSource.createRowNumberBlock(startRowId, sourcePage.getPositionCount());
        }
    }

    private static class ConstantColumn
    implements ColumnAdaptation {
        private final Block singleValueBlock;

        private ConstantColumn(Block singleValueBlock) {
            Preconditions.checkArgument((singleValueBlock.getPositionCount() == 1 ? 1 : 0) != 0, (Object)"ConstantColumnAdaptation singleValueBlock may only contain one position");
            this.singleValueBlock = singleValueBlock;
        }

        @Override
        public Block getBlock(Page sourcePage, long startRowId) {
            return RunLengthEncodedBlock.create((Block)this.singleValueBlock, (int)sourcePage.getPositionCount());
        }
    }

    private static class NullColumn
    implements ColumnAdaptation {
        private final Block nullBlock;

        private NullColumn(Type type) {
            this.nullBlock = type.createBlockBuilder(null, 1, 0).appendNull().build();
        }

        @Override
        public Block getBlock(Page sourcePage, long startRowId) {
            return RunLengthEncodedBlock.create((Block)this.nullBlock, (int)sourcePage.getPositionCount());
        }
    }
}

