/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.plugin.hive.metastore.HiveTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Immutable
public class PartitionFilter {
    private final HiveTableName hiveTableName;
    private final List<String> partitionColumnNames;
    private final TupleDomain<String> partitionKeysFilter;

    @JsonCreator
    public PartitionFilter(@JsonProperty(value="hiveTableName") HiveTableName hiveTableName, @JsonProperty(value="partitionColumnNames") List<String> partitionColumnNames, @JsonProperty(value="partitionKeysFilter") TupleDomain<String> partitionKeysFilter) {
        this.hiveTableName = Objects.requireNonNull(hiveTableName, "hiveTableName is null");
        this.partitionColumnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumnNames, "partitionColumnNames is null"));
        this.partitionKeysFilter = Objects.requireNonNull(partitionKeysFilter, "partitionKeysFilter is null");
    }

    public static PartitionFilter partitionFilter(String databaseName, String tableName, List<String> partitionColumnNames, TupleDomain<String> partitionKeysFilter) {
        return new PartitionFilter(HiveTableName.hiveTableName(databaseName, tableName), partitionColumnNames, partitionKeysFilter);
    }

    @JsonProperty
    public HiveTableName getHiveTableName() {
        return this.hiveTableName;
    }

    @JsonProperty
    public TupleDomain<String> getPartitionKeysFilter() {
        return this.partitionKeysFilter;
    }

    @JsonProperty
    public List<String> getPartitionColumnNames() {
        return this.partitionColumnNames;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("partitionColumnNames", this.partitionColumnNames).add("partitionKeysFilter", this.partitionKeysFilter).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionFilter other = (PartitionFilter)o;
        return Objects.equals(this.hiveTableName, other.hiveTableName) && Objects.equals(this.partitionColumnNames, other.partitionColumnNames) && Objects.equals(this.partitionKeysFilter, other.partitionKeysFilter);
    }

    public int hashCode() {
        return Objects.hash(this.hiveTableName, this.partitionColumnNames, this.partitionKeysFilter);
    }
}

