/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.aws.athena;

import com.google.inject.Inject;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.aws.athena.PartitionProjection;
import io.trino.plugin.hive.aws.athena.PartitionProjectionService;
import io.trino.plugin.hive.metastore.ForwardingHiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreDecorator;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PartitionProjectionMetastoreDecorator
implements HiveMetastoreDecorator {
    private final PartitionProjectionService partitionProjectionService;

    @Inject
    public PartitionProjectionMetastoreDecorator(PartitionProjectionService partitionProjectionService) {
        this.partitionProjectionService = Objects.requireNonNull(partitionProjectionService, "partitionProjectionService is null");
    }

    @Override
    public int getPriority() {
        return 50;
    }

    @Override
    public HiveMetastore decorate(HiveMetastore hiveMetastore) {
        return new PartitionProjectionMetastore(hiveMetastore, this.partitionProjectionService);
    }

    private static class PartitionProjectionMetastore
    extends ForwardingHiveMetastore {
        private final PartitionProjectionService partitionProjectionService;

        public PartitionProjectionMetastore(HiveMetastore hiveMetastore, PartitionProjectionService partitionProjectionService) {
            super(hiveMetastore);
            this.partitionProjectionService = Objects.requireNonNull(partitionProjectionService, "partitionProjectionService is null");
        }

        @Override
        public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
            Table table = super.getTable(databaseName, tableName).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_DROPPED_DURING_QUERY, "Table does not exists: " + tableName));
            Optional<PartitionProjection> projection = this.getPartitionProjection(table);
            if (projection.isPresent()) {
                return projection.get().getProjectedPartitionNamesByFilter(columnNames, partitionKeysFilter);
            }
            return super.getPartitionNamesByFilter(databaseName, tableName, columnNames, partitionKeysFilter);
        }

        @Override
        public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
            Optional<PartitionProjection> projection = this.getPartitionProjection(table);
            if (projection.isPresent()) {
                return projection.get().getProjectedPartitionsByNames(table, partitionNames);
            }
            return super.getPartitionsByNames(table, partitionNames);
        }

        private Optional<PartitionProjection> getPartitionProjection(Table table) {
            return this.partitionProjectionService.getPartitionProjectionFromTable(table).filter(PartitionProjection::isEnabled);
        }
    }
}

