/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.Slice;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.util.ForwardingRecordCursor;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;

public class HiveRecordCursor
extends ForwardingRecordCursor {
    private final RecordCursor delegate;
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Type[] types;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final Object[] objects;
    private final boolean[] nulls;

    public HiveRecordCursor(List<HivePageSourceProvider.ColumnMapping> columnMappings, RecordCursor delegate) {
        Objects.requireNonNull(columnMappings, "columnMappings is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = columnMappings;
        int size = columnMappings.size();
        this.types = new Type[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            DecimalType decimalType;
            DecimalType decimalType2;
            Type type;
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.EMPTY) {
                this.nulls[columnIndex] = true;
            }
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.PREFILLED) continue;
            Object prefilledValue = columnMapping.getPrefilledValue().getValue();
            String name = columnMapping.getHiveColumnHandle().getName();
            this.types[columnIndex] = type = columnMapping.getHiveColumnHandle().getType();
            if (prefilledValue == null) {
                this.nulls[columnIndex] = true;
                continue;
            }
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                this.booleans[columnIndex] = (Boolean)prefilledValue;
                continue;
            }
            if (TinyintType.TINYINT.equals((Object)type)) {
                this.longs[columnIndex] = (Long)prefilledValue;
                continue;
            }
            if (SmallintType.SMALLINT.equals((Object)type)) {
                this.longs[columnIndex] = (Long)prefilledValue;
                continue;
            }
            if (IntegerType.INTEGER.equals((Object)type)) {
                this.longs[columnIndex] = (Long)prefilledValue;
                continue;
            }
            if (BigintType.BIGINT.equals((Object)type)) {
                this.longs[columnIndex] = (Long)prefilledValue;
                continue;
            }
            if (RealType.REAL.equals((Object)type)) {
                this.longs[columnIndex] = (Long)prefilledValue;
                continue;
            }
            if (DoubleType.DOUBLE.equals((Object)type)) {
                this.doubles[columnIndex] = (Double)prefilledValue;
                continue;
            }
            if (type instanceof VarcharType) {
                this.slices[columnIndex] = (Slice)prefilledValue;
                continue;
            }
            if (type instanceof CharType) {
                this.slices[columnIndex] = (Slice)prefilledValue;
                continue;
            }
            if (DateType.DATE.equals((Object)type)) {
                this.longs[columnIndex] = (Long)prefilledValue;
                continue;
            }
            if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
                this.longs[columnIndex] = (Long)prefilledValue;
                continue;
            }
            if (TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)type)) {
                this.longs[columnIndex] = (Long)prefilledValue;
                continue;
            }
            if (type instanceof DecimalType && (decimalType2 = (DecimalType)type).isShort()) {
                this.longs[columnIndex] = (Long)prefilledValue;
                continue;
            }
            if (type instanceof DecimalType && !(decimalType = (DecimalType)type).isShort()) {
                this.objects[columnIndex] = prefilledValue;
                continue;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for prefilled column: %s", type.getDisplayName(), name));
        }
    }

    @Override
    protected RecordCursor delegate() {
        return this.delegate;
    }

    @Override
    public Type getType(int field) {
        return this.types[field];
    }

    @Override
    public boolean getBoolean(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.getBoolean(columnMapping.getIndex());
        }
        return this.booleans[field];
    }

    @Override
    public long getLong(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.getLong(columnMapping.getIndex());
        }
        return this.longs[field];
    }

    @Override
    public double getDouble(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.getDouble(columnMapping.getIndex());
        }
        return this.doubles[field];
    }

    @Override
    public Slice getSlice(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.getSlice(columnMapping.getIndex());
        }
        return this.slices[field];
    }

    @Override
    public Object getObject(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.getObject(columnMapping.getIndex());
        }
        return this.objects[field];
    }

    @Override
    public boolean isNull(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.isNull(columnMapping.getIndex());
        }
        return this.nulls[field];
    }

    @VisibleForTesting
    RecordCursor getRegularColumnRecordCursor() {
        return this.delegate;
    }
}

