/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class HiveAnalyzeProperties {
    public static final String PARTITIONS_PROPERTY = "partitions";
    public static final String COLUMNS_PROPERTY = "columns";
    private final List<PropertyMetadata<?>> analyzeProperties = ImmutableList.of((Object)new PropertyMetadata("partitions", "Partitions to be analyzed", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR)), List.class, null, false, HiveAnalyzeProperties::decodePartitionLists, value -> value), (Object)new PropertyMetadata("columns", "Columns to be analyzed", (Type)new ArrayType((Type)VarcharType.VARCHAR), Set.class, null, false, HiveAnalyzeProperties::decodeColumnNames, value -> value));

    @Inject
    public HiveAnalyzeProperties() {
    }

    public List<PropertyMetadata<?>> getAnalyzeProperties() {
        return this.analyzeProperties;
    }

    public static Optional<List<List<String>>> getPartitionList(Map<String, Object> properties) {
        List partitions = (List)properties.get(PARTITIONS_PROPERTY);
        return Optional.ofNullable(partitions);
    }

    private static List<List<String>> decodePartitionLists(Object object) {
        if (object == null) {
            return null;
        }
        return (List)((Collection)object).stream().peek(partition -> HiveAnalyzeProperties.throwIfNull(partition, PARTITIONS_PROPERTY)).map(partition -> (ImmutableList)((Collection)partition).stream().map(name -> (String)MoreObjects.firstNonNull((Object)((String)name), (Object)"__HIVE_DEFAULT_PARTITION__")).collect(ImmutableList.toImmutableList())).distinct().collect(ImmutableList.toImmutableList());
    }

    public static Optional<Set<String>> getColumnNames(Map<String, Object> properties) {
        Set columns = (Set)properties.get(COLUMNS_PROPERTY);
        return Optional.ofNullable(columns);
    }

    private static Set<String> decodeColumnNames(Object object) {
        if (object == null) {
            return null;
        }
        Collection columns = (Collection)object;
        return (Set)columns.stream().peek(property -> HiveAnalyzeProperties.throwIfNull(property, COLUMNS_PROPERTY)).map(String.class::cast).collect(ImmutableSet.toImmutableSet());
    }

    private static void throwIfNull(Object object, String propertyName) {
        if (object == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("Invalid null value in analyze %s property", propertyName));
        }
    }
}

