/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.plugin.bigquery.BigQueryOptionsConfigurer;
import io.trino.plugin.bigquery.BigQueryRpcConfig;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;

public class RetryOptionsConfigurer
implements BigQueryOptionsConfigurer {
    private final int retries;
    private final Duration timeout;
    private final Duration retryDelay;
    private final double retryMultiplier;

    @Inject
    public RetryOptionsConfigurer(BigQueryRpcConfig rpcConfig) {
        Objects.requireNonNull(rpcConfig, "rpcConfig is null");
        this.retries = rpcConfig.getRetries();
        this.timeout = rpcConfig.getTimeout();
        this.retryDelay = rpcConfig.getRetryDelay();
        this.retryMultiplier = rpcConfig.getRetryMultiplier();
    }

    @Override
    public BigQueryOptions.Builder configure(BigQueryOptions.Builder builder, ConnectorSession session) {
        return (BigQueryOptions.Builder)builder.setRetrySettings(this.retrySettings());
    }

    @Override
    public BigQueryReadSettings.Builder configure(BigQueryReadSettings.Builder builder, ConnectorSession session) {
        try {
            return builder.applyToAllUnaryMethods(methodBuilder -> {
                methodBuilder.setRetrySettings(this.retrySettings());
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private RetrySettings retrySettings() {
        long maxDelay = this.retryDelay.toMillis() * (long)Math.pow(this.retryMultiplier, this.retries);
        return RetrySettings.newBuilder().setMaxAttempts(this.retries).setTotalTimeout(org.threeten.bp.Duration.of((long)this.timeout.toMillis(), (TemporalUnit)ChronoUnit.MILLIS)).setInitialRetryDelay(org.threeten.bp.Duration.of((long)this.retryDelay.toMillis(), (TemporalUnit)ChronoUnit.MILLIS)).setRetryDelayMultiplier(this.retryMultiplier).setMaxRetryDelay(org.threeten.bp.Duration.of((long)maxDelay, (TemporalUnit)ChronoUnit.MILLIS)).build();
    }
}

