/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.auth.Credentials;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.inject.Inject;
import io.trino.plugin.bigquery.BigQueryCredentialsSupplier;
import io.trino.plugin.bigquery.ProxyTransportFactory;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;

public class DefaultBigQueryCredentialsProvider
implements BigQueryCredentialsSupplier {
    private final Optional<ProxyTransportFactory> transportFactory;

    @Inject
    public DefaultBigQueryCredentialsProvider(Optional<ProxyTransportFactory> transportFactory) {
        this.transportFactory = Objects.requireNonNull(transportFactory, "transportFactory is null");
    }

    @Override
    public Optional<Credentials> getCredentials(ConnectorSession session) {
        return this.transportFactory.map(factory -> {
            try {
                return GoogleCredentials.getApplicationDefault((HttpTransportFactory)factory.getTransportOptions().getHttpTransportFactory());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

