/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.bigquery.BigQueryColumnHandle;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.List;

public enum BigQueryPseudoColumn {
    PARTITION_DATE("$partition_date", "_PARTITIONDATE", (Type)DateType.DATE, StandardSQLTypeName.DATE),
    PARTITION_TIME("$partition_time", "_PARTITIONTIME", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS, StandardSQLTypeName.TIMESTAMP);

    private final String trinoColumnName;
    private final String bigqueryColumnName;
    private final Type trinoType;
    private final StandardSQLTypeName bigqueryType;

    private BigQueryPseudoColumn(String trinoColumnName, String bigqueryColumnName, Type type, StandardSQLTypeName bigqueryType) {
        this.trinoColumnName = trinoColumnName;
        this.bigqueryColumnName = bigqueryColumnName;
        this.trinoType = type;
        this.bigqueryType = bigqueryType;
    }

    public String getTrinoColumnName() {
        return this.trinoColumnName;
    }

    public String getBigqueryColumnName() {
        return this.bigqueryColumnName;
    }

    public BigQueryColumnHandle getColumnHandle() {
        return new BigQueryColumnHandle(this.trinoColumnName, this.trinoType, this.bigqueryType, Field.Mode.REQUIRED, null, null, (List<BigQueryColumnHandle>)ImmutableList.of(), null, true);
    }
}

