/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.bigquery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BigQueryColumnHandle
implements ColumnHandle {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BigQueryColumnHandle.class);
    private final String name;
    private final Type trinoType;
    private final StandardSQLTypeName bigqueryType;
    private final Field.Mode mode;
    private final Long precision;
    private final Long scale;
    private final List<BigQueryColumnHandle> subColumns;
    private final String description;
    private final boolean hidden;

    @JsonCreator
    public BigQueryColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="trinoType") Type trinoType, @JsonProperty(value="bigqueryType") StandardSQLTypeName bigqueryType, @JsonProperty(value="mode") Field.Mode mode, @JsonProperty(value="precision") Long precision, @JsonProperty(value="scale") Long scale, @JsonProperty(value="subColumns") List<BigQueryColumnHandle> subColumns, @JsonProperty(value="description") String description, @JsonProperty(value="hidden") boolean hidden) {
        this.name = Objects.requireNonNull(name, "column name cannot be null");
        this.trinoType = Objects.requireNonNull(trinoType, "trinoType is null");
        this.bigqueryType = Objects.requireNonNull(bigqueryType, "bigqueryType is null");
        this.mode = Objects.requireNonNull(mode, "Field mode cannot be null");
        this.precision = precision;
        this.scale = scale;
        this.subColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(subColumns, "subColumns is null"));
        this.description = description;
        this.hidden = hidden;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getTrinoType() {
        return this.trinoType;
    }

    @JsonProperty
    public StandardSQLTypeName getBigqueryType() {
        return this.bigqueryType;
    }

    @JsonProperty
    public Field.Mode getMode() {
        return this.mode;
    }

    @JsonProperty
    public Long getPrecision() {
        return this.precision;
    }

    @JsonProperty
    public Long getScale() {
        return this.scale;
    }

    @JsonProperty
    public List<BigQueryColumnHandle> getSubColumns() {
        return this.subColumns;
    }

    @JsonProperty
    public String description() {
        return this.description;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    public ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.trinoType).setComment(Optional.ofNullable(this.description)).setNullable(this.mode == Field.Mode.NULLABLE).setHidden(this.hidden).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigQueryColumnHandle that = (BigQueryColumnHandle)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.trinoType, that.trinoType) && Objects.equals(this.bigqueryType, that.bigqueryType) && Objects.equals(this.mode, that.mode) && Objects.equals(this.precision, that.precision) && Objects.equals(this.scale, that.scale) && Objects.equals(this.subColumns, that.subColumns) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.trinoType, this.bigqueryType, this.mode, this.precision, this.scale, this.subColumns, this.description);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("trinoType", (Object)this.trinoType).add("bigqueryType", (Object)this.bigqueryType).add("mode", (Object)this.mode).add("precision", (Object)this.precision).add("scale", (Object)this.scale).add("subColumns", this.subColumns).add("description", (Object)this.description).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.name) + SizeOf.sizeOf((Long)this.precision) + SizeOf.sizeOf((Long)this.scale) + SizeOf.estimatedSizeOf(this.subColumns, BigQueryColumnHandle::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.description);
    }
}

