/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.kerberos;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.sun.security.auth.module.Krb5LoginModule;
import io.trino.client.ClientException;
import io.trino.client.auth.kerberos.AbstractUnconstrainedContextProvider;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSException;

public class LoginBasedUnconstrainedContextProvider
extends AbstractUnconstrainedContextProvider {
    private final Optional<String> principal;
    private final Optional<File> keytab;
    private final Optional<File> credentialCache;
    @GuardedBy(value="this")
    private LoginContext loginContext;

    public LoginBasedUnconstrainedContextProvider(Optional<String> principal, Optional<File> kerberosConfig, Optional<File> keytab, Optional<File> credentialCache) {
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.keytab = Objects.requireNonNull(keytab, "keytab is null");
        this.credentialCache = Objects.requireNonNull(credentialCache, "credentialCache is null");
        kerberosConfig.ifPresent(file -> {
            String newValue = file.getAbsolutePath();
            String currentValue = System.getProperty("java.security.krb5.conf");
            Preconditions.checkState((currentValue == null || Objects.equals(currentValue, newValue) ? 1 : 0) != 0, (String)"Refusing to set system property 'java.security.krb5.conf' to '%s', it is already set to '%s'", (Object)newValue, (Object)currentValue);
            Preconditions.checkState((file.exists() && !file.isDirectory() ? 1 : 0) != 0, (String)"Kerberos config file '%s' does not exist or is a directory", (Object)newValue);
            Preconditions.checkState((boolean)file.canRead(), (String)"Kerberos config file '%s' is not readable", (Object)newValue);
            System.setProperty("java.security.krb5.conf", newValue);
        });
    }

    @Override
    public Subject getSubject() {
        return this.loginContext.getSubject();
    }

    @Override
    public void refresh() throws GSSException {
        try {
            this.loginContext = new LoginContext("", null, null, new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    ImmutableMap.Builder options = ImmutableMap.builder();
                    options.put((Object)"refreshKrb5Config", (Object)"true");
                    options.put((Object)"doNotPrompt", (Object)"true");
                    options.put((Object)"useKeyTab", (Object)"true");
                    if (Boolean.getBoolean("trino.client.debugKerberos")) {
                        options.put((Object)"debug", (Object)"true");
                    }
                    LoginBasedUnconstrainedContextProvider.this.keytab.ifPresent(file -> options.put((Object)"keyTab", (Object)file.getAbsolutePath()));
                    LoginBasedUnconstrainedContextProvider.this.credentialCache.ifPresent(file -> {
                        options.put((Object)"ticketCache", (Object)file.getAbsolutePath());
                        options.put((Object)"renewTGT", (Object)"true");
                    });
                    if (!LoginBasedUnconstrainedContextProvider.this.keytab.isPresent() || LoginBasedUnconstrainedContextProvider.this.credentialCache.isPresent()) {
                        options.put((Object)"useTicketCache", (Object)"true");
                    }
                    LoginBasedUnconstrainedContextProvider.this.principal.ifPresent(value -> options.put((Object)"principal", value));
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Map<String, ?>)options.buildOrThrow())};
                }
            });
            this.loginContext.login();
        }
        catch (LoginException e) {
            throw new ClientException(String.format("Kerberos login error for [%s]: %s", this.principal.orElse("not defined"), e.getMessage()), e);
        }
    }
}

