/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.net.HostAndPort;
import io.trino.client.ClientException;
import io.trino.client.PemReader;
import io.trino.client.auth.kerberos.DelegatedConstrainedContextProvider;
import io.trino.client.auth.kerberos.DelegatedUnconstrainedContextProvider;
import io.trino.client.auth.kerberos.GSSContextProvider;
import io.trino.client.auth.kerberos.LoginBasedUnconstrainedContextProvider;
import io.trino.client.auth.kerberos.SpnegoHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import okhttp3.Authenticator;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.internal.tls.LegacyHostnameVerifier;
import org.ietf.jgss.GSSCredential;

public final class OkHttpUtil {
    private OkHttpUtil() {
    }

    public static Interceptor userAgent(String userAgent) {
        return chain -> chain.proceed(chain.request().newBuilder().header("User-Agent", userAgent).build());
    }

    public static Interceptor basicAuth(String user, String password) {
        Objects.requireNonNull(user, "user is null");
        Objects.requireNonNull(password, "password is null");
        if (user.contains(":")) {
            throw new ClientException("Illegal character ':' found in username");
        }
        String credential = Credentials.basic((String)user, (String)password);
        return chain -> chain.proceed(chain.request().newBuilder().header("Authorization", credential).build());
    }

    public static Interceptor tokenAuth(String accessToken) {
        Objects.requireNonNull(accessToken, "accessToken is null");
        Preconditions.checkArgument((boolean)CharMatcher.inRange((char)'!', (char)'~').matchesAllOf((CharSequence)accessToken));
        return chain -> chain.proceed(chain.request().newBuilder().addHeader("Authorization", "Bearer " + accessToken).build());
    }

    public static void setupTimeouts(OkHttpClient.Builder clientBuilder, int timeout, TimeUnit unit) {
        clientBuilder.connectTimeout((long)timeout, unit).readTimeout((long)timeout, unit).writeTimeout((long)timeout, unit);
    }

    public static void setupCookieJar(OkHttpClient.Builder clientBuilder) {
        clientBuilder.cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)new CookieManager()));
    }

    public static void setupSocksProxy(OkHttpClient.Builder clientBuilder, Optional<HostAndPort> socksProxy) {
        OkHttpUtil.setupProxy(clientBuilder, socksProxy, Proxy.Type.SOCKS);
    }

    public static void setupHttpProxy(OkHttpClient.Builder clientBuilder, Optional<HostAndPort> httpProxy) {
        OkHttpUtil.setupProxy(clientBuilder, httpProxy, Proxy.Type.HTTP);
    }

    public static void setupProxy(OkHttpClient.Builder clientBuilder, Optional<HostAndPort> proxy, Proxy.Type type) {
        proxy.map(OkHttpUtil::toUnresolvedAddress).map(address -> new Proxy(type, (SocketAddress)address)).ifPresent(arg_0 -> ((OkHttpClient.Builder)clientBuilder).proxy(arg_0));
    }

    private static InetSocketAddress toUnresolvedAddress(HostAndPort address) {
        return InetSocketAddress.createUnresolved(address.getHost(), address.getPort());
    }

    public static void setupInsecureSsl(OkHttpClient.Builder clientBuilder) {
        try {
            X509TrustManager trustAllCerts = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    throw new UnsupportedOperationException("checkClientTrusted should not be called");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{trustAllCerts}, new SecureRandom());
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustAllCerts);
            clientBuilder.hostnameVerifier((hostname, session) -> true);
        }
        catch (GeneralSecurityException e) {
            throw new ClientException("Error setting up SSL: " + e.getMessage(), e);
        }
    }

    public static void setupSsl(OkHttpClient.Builder clientBuilder, Optional<String> keyStorePath, Optional<String> keyStorePassword, Optional<String> keyStoreType, Optional<String> trustStorePath, Optional<String> trustStorePassword, Optional<String> trustStoreType, boolean useSystemTrustStore) {
        if (!(keyStorePath.isPresent() || trustStorePath.isPresent() || useSystemTrustStore)) {
            return;
        }
        try {
            KeyStore keyStore = null;
            KeyManager[] keyManagers = null;
            if (keyStorePath.isPresent()) {
                char[] keyManagerPassword;
                try {
                    keyStore = PemReader.loadKeyStore(new File(keyStorePath.get()), new File(keyStorePath.get()), keyStorePassword);
                    keyManagerPassword = new char[]{};
                }
                catch (IOException | GeneralSecurityException ignored) {
                    keyManagerPassword = keyStorePassword.map(String::toCharArray).orElse(null);
                    keyStore = KeyStore.getInstance(keyStoreType.orElseGet(KeyStore::getDefaultType));
                    try (FileInputStream in = new FileInputStream(keyStorePath.get());){
                        keyStore.load(in, keyManagerPassword);
                    }
                }
                OkHttpUtil.validateCertificates(keyStore);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, keyManagerPassword);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            KeyStore trustStore = keyStore;
            if (useSystemTrustStore) {
                trustStore = OkHttpUtil.loadSystemTrustStore(trustStoreType);
            } else if (trustStorePath.isPresent()) {
                trustStore = OkHttpUtil.loadTrustStore(new File(trustStorePath.get()), trustStorePassword, trustStoreType);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new RuntimeException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            clientBuilder.hostnameVerifier(LegacyHostnameVerifier.INSTANCE);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ClientException("Error setting up SSL: " + e.getMessage(), e);
        }
    }

    private static void validateCertificates(KeyStore keyStore) throws GeneralSecurityException {
        for (String alias : Collections.list(keyStore.aliases())) {
            Certificate certificate;
            if (!keyStore.isKeyEntry(alias) || !((certificate = keyStore.getCertificate(alias)) instanceof X509Certificate)) continue;
            try {
                ((X509Certificate)certificate).checkValidity();
            }
            catch (CertificateExpiredException e) {
                throw new CertificateExpiredException("KeyStore certificate is expired: " + e.getMessage());
            }
            catch (CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException("KeyStore certificate is not yet valid: " + e.getMessage());
            }
        }
    }

    private static KeyStore loadTrustStore(File trustStorePath, Optional<String> trustStorePassword, Optional<String> trustStoreType) throws IOException, GeneralSecurityException {
        KeyStore trustStore = KeyStore.getInstance(trustStoreType.orElseGet(KeyStore::getDefaultType));
        try {
            List<X509Certificate> certificateChain = PemReader.readCertificateChain(trustStorePath);
            if (!certificateChain.isEmpty()) {
                trustStore.load(null, null);
                for (X509Certificate certificate : certificateChain) {
                    X500Principal principal = certificate.getSubjectX500Principal();
                    trustStore.setCertificateEntry(principal.getName(), certificate);
                }
                return trustStore;
            }
        }
        catch (IOException | GeneralSecurityException certificateChain) {
            // empty catch block
        }
        try (FileInputStream in = new FileInputStream(trustStorePath);){
            trustStore.load(in, trustStorePassword.map(String::toCharArray).orElse(null));
        }
        return trustStore;
    }

    private static KeyStore loadSystemTrustStore(Optional<String> trustStoreType) throws IOException, GeneralSecurityException {
        String osName = Optional.ofNullable(StandardSystemProperty.OS_NAME.value()).orElse("");
        Optional<String> systemTrustStoreType = trustStoreType;
        if (!systemTrustStoreType.isPresent()) {
            if (osName.contains("Windows")) {
                systemTrustStoreType = Optional.of("Windows-ROOT");
            } else if (osName.contains("Mac")) {
                systemTrustStoreType = Optional.of("KeychainStore");
            }
        }
        KeyStore trustStore = KeyStore.getInstance(systemTrustStoreType.orElseGet(KeyStore::getDefaultType));
        trustStore.load(null, null);
        return trustStore;
    }

    public static void setupKerberos(OkHttpClient.Builder clientBuilder, String servicePrincipalPattern, String remoteServiceName, boolean useCanonicalHostname, Optional<String> principal, Optional<File> kerberosConfig, Optional<File> keytab, Optional<File> credentialCache, boolean delegatedKerberos, Optional<GSSCredential> gssCredential) {
        GSSContextProvider contextProvider = delegatedKerberos ? OkHttpUtil.getDelegatedGSSContextProvider(gssCredential) : new LoginBasedUnconstrainedContextProvider(principal, kerberosConfig, keytab, credentialCache);
        SpnegoHandler handler = new SpnegoHandler(servicePrincipalPattern, remoteServiceName, useCanonicalHostname, contextProvider);
        clientBuilder.addInterceptor((Interceptor)handler);
        clientBuilder.authenticator((Authenticator)handler);
    }

    public static void setupAlternateHostnameVerification(OkHttpClient.Builder clientBuilder, String alternativeHostname) {
        clientBuilder.hostnameVerifier((hostname, session) -> LegacyHostnameVerifier.INSTANCE.verify(alternativeHostname, session));
    }

    private static GSSContextProvider getDelegatedGSSContextProvider(Optional<GSSCredential> gssCredential) {
        return gssCredential.map(DelegatedConstrainedContextProvider::new).map(gssCred -> gssCred).orElse(new DelegatedUnconstrainedContextProvider());
    }
}

