/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import com.google.common.base.Preconditions;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.resourcegroups.ResourceGroupIdTemplate;
import io.trino.plugin.resourcegroups.ResourceGroupSelector;
import io.trino.plugin.resourcegroups.db.ResourceGroupsDao;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jdbi.v3.core.JdbiException;

public class DbSourceExactMatchSelector
implements ResourceGroupSelector {
    private static final Logger log = Logger.get(DbSourceExactMatchSelector.class);
    private static final JsonCodec<ResourceGroupId> resourceGroupIdCodec = JsonCodec.jsonCodec(ResourceGroupId.class);
    private final ResourceGroupsDao dao;
    private final String environment;
    private final AtomicReference<Long> daoOfflineStart = new AtomicReference();

    public DbSourceExactMatchSelector(String environment, ResourceGroupsDao dao) {
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.dao = Objects.requireNonNull(dao, "dao is null");
    }

    @Override
    public Optional<SelectionContext<ResourceGroupIdTemplate>> match(SelectionCriteria criteria) {
        if (criteria.getSource().isEmpty()) {
            return Optional.empty();
        }
        try {
            ResourceGroupId groupId;
            String resourceGroupId = this.dao.getExactMatchResourceGroup(this.environment, (String)criteria.getSource().get(), criteria.getQueryType().orElse(""));
            Long start = this.daoOfflineStart.get();
            if (start != null && this.daoOfflineStart.compareAndSet(start, null)) {
                log.info("Successfully fetched exact match selectors after %s", new Object[]{Duration.nanosSince((long)start)});
            }
            if (resourceGroupId == null) {
                return Optional.empty();
            }
            try {
                groupId = (ResourceGroupId)resourceGroupIdCodec.fromJson(resourceGroupId);
            }
            catch (IllegalArgumentException e) {
                log.warn("Failed to decode resource group from DB: %s", new Object[]{resourceGroupId});
                return Optional.empty();
            }
            return Optional.of(new SelectionContext(groupId, (Object)DbSourceExactMatchSelector.toTemplate(groupId)));
        }
        catch (JdbiException e) {
            if (this.daoOfflineStart.compareAndSet(null, System.nanoTime())) {
                log.warn((Throwable)e, "Failed to fetch exact match resource group selectors");
            }
            return Optional.empty();
        }
    }

    private static ResourceGroupIdTemplate toTemplate(ResourceGroupId groupId) {
        ResourceGroupIdTemplate template = new ResourceGroupIdTemplate(groupId.toString());
        Preconditions.checkArgument((boolean)template.getVariableNames().isEmpty(), (String)"Group ID contains variable references: %s", (Object)groupId);
        return template;
    }
}

