/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.spi.session.ResourceEstimates;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class SelectorResourceEstimate {
    private final Optional<Range<Duration>> executionTime;
    private final Optional<Range<Duration>> cpuTime;
    private final Optional<Range<DataSize>> peakMemory;

    @JsonCreator
    public SelectorResourceEstimate(@JsonProperty(value="executionTime") Optional<Range<Duration>> executionTime, @JsonProperty(value="cpuTime") Optional<Range<Duration>> cpuTime, @JsonProperty(value="peakMemory") Optional<Range<DataSize>> peakMemory) {
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is null");
        this.cpuTime = Objects.requireNonNull(cpuTime, "cpuTime is null");
        this.peakMemory = Objects.requireNonNull(peakMemory, "peakMemory is null");
    }

    @JsonProperty
    public Optional<Range<Duration>> getExecutionTime() {
        return this.executionTime;
    }

    @JsonProperty
    public Optional<Range<Duration>> getCpuTime() {
        return this.cpuTime;
    }

    @JsonProperty
    public Optional<Range<DataSize>> getPeakMemory() {
        return this.peakMemory;
    }

    boolean match(ResourceEstimates resourceEstimates) {
        Optional<DataSize> peakMemoryEstimate;
        Optional<Duration> cpuTimeEstimate;
        Optional<Duration> executionTimeEstimate;
        if (this.executionTime.isPresent() && ((executionTimeEstimate = resourceEstimates.getExecutionTime().map(value -> new Duration((double)value.toMillis(), TimeUnit.MILLISECONDS))).isEmpty() || !this.executionTime.get().contains(executionTimeEstimate.get()))) {
            return false;
        }
        if (this.cpuTime.isPresent() && ((cpuTimeEstimate = resourceEstimates.getCpuTime().map(value -> new Duration((double)value.toMillis(), TimeUnit.MILLISECONDS))).isEmpty() || !this.cpuTime.get().contains(cpuTimeEstimate.get()))) {
            return false;
        }
        return !this.peakMemory.isPresent() || !(peakMemoryEstimate = resourceEstimates.getPeakMemoryBytes().map(DataSize::ofBytes)).isEmpty() && this.peakMemory.get().contains(peakMemoryEstimate.get());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("executionTime", this.executionTime).add("cpuTime", this.cpuTime).add("peakMemory", this.peakMemory).toString();
    }

    public int hashCode() {
        return Objects.hash(this.executionTime, this.cpuTime, this.peakMemory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorResourceEstimate other = (SelectorResourceEstimate)o;
        return Objects.equals(this.executionTime, other.executionTime) && Objects.equals(this.cpuTime, other.cpuTime) && Objects.equals(this.peakMemory, other.peakMemory);
    }

    public static class Range<T extends Comparable<T>> {
        private final Optional<T> min;
        private final Optional<T> max;

        @JsonCreator
        public Range(@JsonProperty(value="min") Optional<T> min, @JsonProperty(value="max") Optional<T> max) {
            this.min = Objects.requireNonNull(min, "min is null");
            this.max = Objects.requireNonNull(max, "max is null");
        }

        boolean contains(T value) {
            return !(!this.min.isEmpty() && ((Comparable)this.min.get()).compareTo(value) > 0 || !this.max.isEmpty() && ((Comparable)this.max.get()).compareTo(value) < 0);
        }

        @JsonProperty
        public Optional<T> getMin() {
            return this.min;
        }

        @JsonProperty
        public Optional<T> getMax() {
            return this.max;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("min", this.min).add("max", this.max).toString();
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range other = (Range)o;
            return Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
        }
    }
}

