/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.annotations.VisibleForTesting;
import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.base.Strings;
import com.google.shaded.shaded.common.base.Throwables;
import com.qubole.rubix.common.metrics.CustomMetricsReporterProvider;
import com.qubole.rubix.common.utils.ClusterUtil;
import com.qubole.rubix.core.BasicCachingFileSystemStats;
import com.qubole.rubix.core.CachingFileSystemStatsProvider;
import com.qubole.rubix.core.CachingInputStream;
import com.qubole.rubix.core.ClusterManagerInitilizationException;
import com.qubole.rubix.core.DetailedCachingFileSystemStats;
import com.qubole.rubix.core.DummyModeCachingInputStream;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.ClusterManager;
import com.qubole.rubix.spi.ClusterType;
import com.qubole.rubix.spi.thrift.BookKeeperService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.weakref.shaded.jmx.MBeanExporter;

public abstract class CachingFileSystem<T extends FileSystem>
extends FilterFileSystem {
    private static final Log log = LogFactory.getLog(CachingFileSystem.class);
    private static volatile BookKeeperFactory bookKeeperFactory = new BookKeeperFactory();
    public static final String STATS_MBEAN_NAME_BASE = "rubix:name=stats";
    public static final String DETAILED_STATS_MBEAN_NAME_BASE = "rubix:name=stats,type=detailed";
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static volatile String statsMBeanName = "rubix:name=stats";
    private static volatile String detailedStatsMBeanName = "rubix:name=stats,type=detailed";
    private static volatile ClusterManager clusterManager;
    private static volatile CachingFileSystemStatsProvider stats;
    private boolean isRubixSchemeUsed;
    private URI uri;
    private Path workingDir;
    private long splitSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(Configuration conf, ClusterType clusterType) throws IOException {
        if (initialized.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = initialized;
        synchronized (atomicBoolean) {
            if (initialized.get()) {
                return;
            }
            if (!CacheConfig.isEmbeddedModeEnabled(conf)) {
                CachingFileSystem.initializeStats(conf);
            }
            try {
                CachingFileSystem.initializeClusterManager(conf, clusterType);
            }
            catch (ClusterManagerInitilizationException e) {
                throw new IOException(e);
            }
            initialized.set(true);
        }
    }

    @VisibleForTesting
    public static void deinitialize() {
        clusterManager = null;
        statsMBeanName = STATS_MBEAN_NAME_BASE;
        detailedStatsMBeanName = DETAILED_STATS_MBEAN_NAME_BASE;
        initialized.set(false);
    }

    private static void initializeStats(Configuration conf) {
        MBeanExporter exporter = new MBeanExporter(ManagementFactory.getPlatformMBeanServer());
        stats = new CachingFileSystemStatsProvider();
        try {
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(statsMBeanName))) {
                exporter.unexport(statsMBeanName);
            }
            if (!ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(statsMBeanName))) {
                exporter.export(statsMBeanName, (Object)new BasicCachingFileSystemStats(stats, bookKeeperFactory, conf));
            }
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(detailedStatsMBeanName))) {
                exporter.unexport(detailedStatsMBeanName);
            }
            if (!ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(detailedStatsMBeanName))) {
                exporter.export(detailedStatsMBeanName, (Object)new DetailedCachingFileSystemStats(stats, bookKeeperFactory, conf));
            }
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Could not load MBean", e);
        }
    }

    private static void initializeClusterManager(Configuration conf, ClusterType clusterType) throws ClusterManagerInitilizationException {
        if (clusterManager != null) {
            return;
        }
        String clusterManagerClassName = CacheConfig.getClusterManagerClass(conf, clusterType);
        log.debug((Object)("Initializing cluster manager : " + clusterManagerClassName));
        try {
            Class clusterManagerClass = conf.getClassByName(clusterManagerClassName);
            Constructor constructor = clusterManagerClass.getConstructor(new Class[0]);
            ClusterManager manager = (ClusterManager)constructor.newInstance(new Object[0]);
            manager.initialize(conf);
            clusterManager = manager;
        }
        catch (Exception ex) {
            String errorMessage = "Not able to initialize ClusterManager class: " + clusterManagerClassName;
            log.error((Object)errorMessage, (Throwable)ex);
            throw new ClusterManagerInitilizationException(errorMessage, ex);
        }
    }

    private Class<T> getTypeParameterClass() {
        Type type = ((Object)((Object)this)).getClass().getGenericSuperclass();
        ParameterizedType paramType = (ParameterizedType)type;
        return (Class)paramType.getActualTypeArguments()[0];
    }

    public CachingFileSystem() {
        try {
            this.fs = (FileSystem)this.getTypeParameterClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error((Object)"cannot instantiate base filesystem ", (Throwable)e);
            Throwables.propagate(e);
        }
    }

    public FileSystem getRemoteFileSystem() {
        return this.fs;
    }

    public static void setLocalBookKeeper(Configuration configuration, BookKeeperService.Iface bookKeeper, String statsMbeanSuffix) {
        Preconditions.checkState(!initialized.get(), "LocalBookKeeper should be set before opening up the Filesystem to clients");
        bookKeeperFactory = new BookKeeperFactory(bookKeeper);
        if (!Strings.isNullOrEmpty(statsMbeanSuffix)) {
            statsMBeanName = statsMBeanName + "," + statsMbeanSuffix;
            detailedStatsMBeanName = detailedStatsMBeanName + "," + statsMbeanSuffix;
        }
        CachingFileSystem.initializeStats(configuration);
    }

    public abstract String getScheme();

    public void initialize(URI uri, Configuration conf) throws IOException {
        conf = ClusterUtil.applyRubixSiteConfig(conf);
        CachingFileSystem.initialize(conf, this.getClusterType());
        super.initialize(this.getOriginalURI(uri), conf);
        CustomMetricsReporterProvider.initialize(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified((FileSystem)this);
        this.isRubixSchemeUsed = uri.getScheme().equals("rubix");
        this.splitSize = CacheConfig.getCacheFileSplitSize(conf);
    }

    public abstract ClusterType getClusterType();

    public URI getUri() {
        return this.uri;
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        if (CacheUtil.skipCache(path.toString(), this.getConf())) {
            return this.fs.open(path, bufferSize);
        }
        Path originalPath = new Path(this.getOriginalURI(path.toUri()).getScheme(), path.toUri().getAuthority(), path.toUri().getPath());
        if (CacheConfig.isDummyModeEnabled(this.getConf())) {
            return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new DummyModeCachingInputStream((FileSystem)this, originalPath, this.getConf(), stats, clusterManager.getClusterType(), bookKeeperFactory, this.fs, bufferSize, this.statistics), CacheConfig.getBlockSize(this.getConf())));
        }
        try {
            return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new CachingInputStream(originalPath, this.getConf(), stats, clusterManager.getClusterType(), bookKeeperFactory, this.fs, bufferSize, this.statistics), CacheConfig.getBlockSize(this.getConf())));
        }
        catch (Exception e) {
            if (CacheConfig.isStrictMode(this.getConf())) {
                log.error((Object)"Error in opening Caching Input Stream", (Throwable)e);
                throw e;
            }
            log.warn((Object)"Error in opening Caching Input Stream, skipping cache", (Throwable)e);
            return this.fs.open(path, bufferSize);
        }
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean b, int i, short i1, long l, Progressable progressable) throws IOException {
        return this.fs.create(path, fsPermission, b, i, i1, l, progressable);
    }

    public FSDataOutputStream append(Path path, int i, Progressable progressable) throws IOException {
        return this.fs.append(path, i, progressable);
    }

    public boolean rename(Path path, Path path1) throws IOException {
        return this.fs.rename(path, path1);
    }

    public boolean delete(Path path) throws IOException {
        return this.fs.delete(path);
    }

    public boolean delete(Path path, boolean b) throws IOException {
        return this.fs.delete(path, b);
    }

    public FileStatus[] listStatus(Path path) throws FileNotFoundException, IOException {
        FileStatus[] files = this.fs.listStatus(path);
        for (int i = 0; i < files.length; ++i) {
            files[i].setPath(this.getRubixPath(files[i].getPath(), this.isRubixSchemeUsed));
        }
        return files;
    }

    public void setWorkingDirectory(Path path) {
        this.workingDir = path;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        return this.fs.mkdirs(path, fsPermission);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        FileStatus originalStatus = this.fs.getFileStatus(path);
        originalStatus.setPath(this.getRubixPath(originalStatus.getPath(), this.isRubixSchemeUsed));
        return originalStatus;
    }

    private Path getRubixPath(Path remotePath, boolean isRubixSchemeUsed) {
        String remotePathScheme = remotePath.toUri().getScheme();
        if (remotePathScheme.equals(this.getScheme()) && isRubixSchemeUsed) {
            return new Path("rubix", remotePath.toUri().getAuthority(), remotePath.toUri().getPath());
        }
        return remotePath;
    }

    private URI getOriginalURI(URI actualURI) {
        String actualScheme = actualURI.getScheme();
        if (!"rubix".equals(actualScheme)) {
            return actualURI;
        }
        return URI.create(this.getScheme() + "://" + actualURI.getAuthority());
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path path) throws IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private final RemoteIterator<LocatedFileStatus> stats;
            {
                this.stats = CachingFileSystem.this.fs.listLocatedStatus(path);
            }

            public boolean hasNext() throws IOException {
                return this.stats.hasNext();
            }

            public LocatedFileStatus next() throws IOException {
                LocatedFileStatus status = (LocatedFileStatus)this.stats.next();
                BlockLocation[] locations = status.isFile() ? CachingFileSystem.this.getFileBlockLocations((FileStatus)status, 0L, status.getLen()) : null;
                return new LocatedFileStatus((FileStatus)status, locations);
            }
        };
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        if (CacheConfig.isEmbeddedModeEnabled(this.getConf()) && !bookKeeperFactory.isBookKeeperInitialized() || CacheUtil.skipCache(file.getPath().toString(), this.getConf())) {
            return this.fs.getFileBlockLocations(file, start, len);
        }
        List<String> nodes = clusterManager.getNodes();
        if (nodes == null) {
            return this.fs.getFileBlockLocations(file, start, len);
        }
        if (start >= 0L && len >= 0L) {
            if (file.getLen() < start) {
                return new BlockLocation[0];
            }
            BlockLocation[] blockLocations = new BlockLocation[(int)Math.ceil((double)file.getLen() / (double)this.splitSize)];
            int blockNumber = 0;
            for (long i = 0L; i < file.getLen(); i += this.splitSize) {
                long end = i + this.splitSize;
                if (end > file.getLen()) {
                    end = file.getLen();
                }
                String key = file.getPath().toString() + i + end;
                String nodeName = clusterManager.locateKey(key);
                String[] name = new String[]{nodeName};
                String[] host = new String[]{nodeName};
                blockLocations[blockNumber++] = new BlockLocation(name, host, i, end - i);
                log.debug((Object)String.format("BlockLocation %s %d %d %s totalHosts: %s", file.getPath().toString(), i, end - i, host[0], nodes.size()));
            }
            return blockLocations;
        }
        throw new IllegalArgumentException("Invalid start or len parameter");
    }
}

