/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.common.metrics;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.qubole.rubix.common.metrics.BookKeeperMetricsFilter;
import com.qubole.rubix.common.metrics.CustomMetricsReporterProvider;
import com.qubole.rubix.common.metrics.MetricsReporterType;
import com.qubole.rubix.common.utils.ClusterUtil;
import com.qubole.rubix.spi.CacheConfig;
import com.readytalk.metrics.StatsDReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class BookKeeperMetrics
implements AutoCloseable {
    private static Log log = LogFactory.getLog(BookKeeperMetrics.class);
    private final Configuration conf;
    private final MetricRegistry metrics;
    private final BookKeeperMetricsFilter metricsFilter;
    protected final Set<Closeable> reporters = new HashSet<Closeable>();

    public BookKeeperMetrics(Configuration conf, MetricRegistry metrics) {
        this.conf = conf;
        this.metrics = metrics;
        this.metricsFilter = new BookKeeperMetricsFilter(conf);
        this.initializeReporters();
    }

    public BookKeeperMetricsFilter getMetricsFilter() {
        return this.metricsFilter;
    }

    public MetricRegistry getMetricsRegistry() {
        return this.metrics;
    }

    protected void initializeReporters() {
        Set<MetricsReporterType> metricsReporterTypes = ClusterUtil.getMetricsReporters(this.conf);
        for (MetricsReporterType reporter : metricsReporterTypes) {
            switch (reporter) {
                case JMX: {
                    JmxReporter jmxReporter = JmxReporter.forRegistry(this.metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(this.metricsFilter).build();
                    log.debug((Object)"Reporting metrics to JMX");
                    jmxReporter.start();
                    this.reporters.add(jmxReporter);
                    break;
                }
                case STATSD: {
                    if (!CacheConfig.isOnMaster(this.conf)) {
                        CacheConfig.setStatsDMetricsHost(this.conf, ClusterUtil.getMasterHostname(this.conf));
                    }
                    StatsDReporter statsDReporter = StatsDReporter.forRegistry(this.metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(this.metricsFilter).build(CacheConfig.getStatsDMetricsHost(this.conf), CacheConfig.getStatsDMetricsPort(this.conf));
                    log.debug((Object)String.format("Reporting metrics to StatsD [%s:%d]", CacheConfig.getStatsDMetricsHost(this.conf), CacheConfig.getStatsDMetricsPort(this.conf)));
                    statsDReporter.start(CacheConfig.getMetricsReportingInterval(this.conf), TimeUnit.MILLISECONDS);
                    this.reporters.add(statsDReporter);
                    break;
                }
                case GANGLIA: {
                    if (!CacheConfig.isOnMaster(this.conf)) {
                        CacheConfig.setGangliaMetricsHost(this.conf, ClusterUtil.getMasterHostname(this.conf));
                    }
                    log.debug((Object)String.format("Reporting metrics to Ganglia [%s:%s]", CacheConfig.getGangliaMetricsHost(this.conf), CacheConfig.getGangliaMetricsPort(this.conf)));
                    GMetric ganglia = new GMetric(CacheConfig.getGangliaMetricsHost(this.conf), CacheConfig.getGangliaMetricsPort(this.conf), GMetric.UDPAddressingMode.MULTICAST, 1);
                    GangliaReporter gangliaReporter = GangliaReporter.forRegistry(this.metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(this.metricsFilter).build(ganglia);
                    gangliaReporter.start(CacheConfig.getMetricsReportingInterval(this.conf), TimeUnit.MILLISECONDS);
                    this.reporters.add(gangliaReporter);
                    break;
                }
                case CUSTOM: {
                    CustomMetricsReporterProvider.initialize(this.conf, Optional.of(this.metrics));
                    this.reporters.add(CustomMetricsReporterProvider.getCustomMetricsReporter());
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (Closeable reporter : this.reporters) {
            reporter.close();
        }
    }

    public static enum ValidationMetric {
        CACHING_VALIDATION_SUCCESS_GAUGE("rubix.bookkeeper.gauge.caching_validation_success"),
        FILE_VALIDATION_SUCCESS_GAUGE("rubix.bookkeeper.gauge.file_validation_success");

        private final String metricName;

        private ValidationMetric(String metricName) {
            this.metricName = metricName;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public static Set<String> getAllNames() {
            HashSet<String> names = new HashSet<String>();
            for (ValidationMetric metric : ValidationMetric.values()) {
                names.add(metric.getMetricName());
            }
            return names;
        }
    }

    public static enum HealthMetric {
        LIVE_WORKER_GAUGE("rubix.bookkeeper.gauge.live_workers"),
        CACHING_VALIDATED_WORKER_GAUGE("rubix.bookkeeper.gauge.caching_validated_workers"),
        FILE_VALIDATED_WORKER_GAUGE("rubix.bookkeeper.gauge.file_validated_workers");

        private final String metricName;

        private HealthMetric(String metricName) {
            this.metricName = metricName;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public static Set<String> getAllNames() {
            HashSet<String> names = new HashSet<String>();
            for (HealthMetric metric : HealthMetric.values()) {
                names.add(metric.getMetricName());
            }
            return names;
        }
    }

    public static enum CacheMetric {
        CACHE_EVICTION_COUNT("rubix.bookkeeper.count.cache_eviction"),
        CACHE_INVALIDATION_COUNT("rubix.bookkeeper.count.cache_invalidation"),
        CACHE_EXPIRY_COUNT("rubix.bookkeeper.count.cache_expiry"),
        CACHE_HIT_RATE_GAUGE("rubix.bookkeeper.gauge.cache_hit_rate"),
        CACHE_MISS_RATE_GAUGE("rubix.bookkeeper.gauge.cache_miss_rate"),
        CACHE_SIZE_GAUGE("rubix.bookkeeper.gauge.cache_size_mb"),
        CACHE_AVAILABLE_SIZE_GAUGE("rubix.bookkeeper.gauge.available_cache_size_mb"),
        TOTAL_REQUEST_COUNT("rubix.bookkeeper.count.total_request"),
        CACHE_REQUEST_COUNT("rubix.bookkeeper.count.cache_request"),
        NONLOCAL_REQUEST_COUNT("rubix.bookkeeper.count.nonlocal_request"),
        REMOTE_REQUEST_COUNT("rubix.bookkeeper.count.remote_request"),
        TOTAL_ASYNC_REQUEST_COUNT("rubix.bookkeeper.count.total_async_request"),
        PROCESSED_ASYNC_REQUEST_COUNT("rubix.bookkeeper.count.processed_async_request"),
        ASYNC_QUEUE_SIZE_GAUGE("rubix.bookkeeper.gauge.async_queue_size"),
        ASYNC_DOWNLOADED_MB_COUNT("rubix.bookkeeper.count.async_downloaded_mb"),
        ASYNC_DOWNLOAD_TIME_COUNT("rubix.bookkeeper.count.async_download_time"),
        LDTS_CACHING_EXCEPTION("rubix.ldts.exception.trasnsferdata");

        private final String metricName;

        private CacheMetric(String metricName) {
            this.metricName = metricName;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public static Set<String> getAllNames() {
            HashSet<String> names = new HashSet<String>();
            for (CacheMetric metric : CacheMetric.values()) {
                names.add(metric.getMetricName());
            }
            return names;
        }
    }

    public static enum LDTSJvmMetric {
        LDTS_JVM_GC_PREFIX("rubix.ldts.jvm.gc"),
        LDTS_JVM_MEMORY_PREFIX("rubix.ldts.jvm.memory"),
        LDTS_JVM_THREADS_PREFIX("rubix.ldts.jvm.threads");

        private final String metricName;

        private LDTSJvmMetric(String metricName) {
            this.metricName = metricName;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public static Set<String> getAllNames() {
            HashSet<String> names = new HashSet<String>();
            for (LDTSJvmMetric metric : LDTSJvmMetric.values()) {
                names.add(metric.getMetricName());
            }
            return names;
        }
    }

    public static enum BookKeeperJvmMetric {
        BOOKKEEPER_JVM_GC_PREFIX("rubix.bookkeeper.jvm.gc"),
        BOOKKEEPER_JVM_MEMORY_PREFIX("rubix.bookkeeper.jvm.memory"),
        BOOKKEEPER_JVM_THREADS_PREFIX("rubix.bookkeeper.jvm.threads");

        private final String metricName;

        private BookKeeperJvmMetric(String metricName) {
            this.metricName = metricName;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public static Set<String> getAllNames() {
            HashSet<String> names = new HashSet<String>();
            for (BookKeeperJvmMetric metric : BookKeeperJvmMetric.values()) {
                names.add(metric.getMetricName());
            }
            return names;
        }
    }
}

