/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.LongTimestampWithTimeZoneType;
import io.trino.spi.type.ShortTimestampWithTimeZoneType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TimestampWithTimeZoneType
extends AbstractType
implements FixedWidthType {
    public static final int MAX_PRECISION = 12;
    public static final int MAX_SHORT_PRECISION = 3;
    public static final int DEFAULT_PRECISION = 3;
    private static final TimestampWithTimeZoneType[] TYPES = new TimestampWithTimeZoneType[13];
    public static final TimestampWithTimeZoneType TIMESTAMP_TZ_SECONDS;
    public static final TimestampWithTimeZoneType TIMESTAMP_TZ_MILLIS;
    public static final TimestampWithTimeZoneType TIMESTAMP_TZ_MICROS;
    public static final TimestampWithTimeZoneType TIMESTAMP_TZ_NANOS;
    public static final TimestampWithTimeZoneType TIMESTAMP_TZ_PICOS;
    private final int precision;

    public static TimestampWithTimeZoneType createTimestampWithTimeZoneType(int precision) {
        if (precision < 0 || precision > 12) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("TIMESTAMP WITH TIME ZONE precision must be in range [0, %s]: %s", 12, precision));
        }
        return TYPES[precision];
    }

    TimestampWithTimeZoneType(int precision, Class<?> javaType) {
        super(new TypeSignature("timestamp with time zone", TypeSignatureParameter.numericParameter(precision)), javaType);
        if (precision < 0 || precision > 12) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [0, %s]", 12));
        }
        this.precision = precision;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final boolean isShort() {
        return this.precision <= 3;
    }

    @Override
    public final boolean isComparable() {
        return true;
    }

    @Override
    public final boolean isOrderable() {
        return true;
    }

    static {
        for (int precision = 0; precision <= 12; ++precision) {
            TimestampWithTimeZoneType.TYPES[precision] = precision <= 3 ? new ShortTimestampWithTimeZoneType(precision) : new LongTimestampWithTimeZoneType(precision);
        }
        TIMESTAMP_TZ_SECONDS = TimestampWithTimeZoneType.createTimestampWithTimeZoneType(0);
        TIMESTAMP_TZ_MILLIS = TimestampWithTimeZoneType.createTimestampWithTimeZoneType(3);
        TIMESTAMP_TZ_MICROS = TimestampWithTimeZoneType.createTimestampWithTimeZoneType(6);
        TIMESTAMP_TZ_NANOS = TimestampWithTimeZoneType.createTimestampWithTimeZoneType(9);
        TIMESTAMP_TZ_PICOS = TimestampWithTimeZoneType.createTimestampWithTimeZoneType(12);
    }
}

