/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandles;
import java.util.Optional;

class ShortTimestampType
extends TimestampType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(ShortTimestampType.class, MethodHandles.lookup(), Long.TYPE);
    private final Type.Range range;

    public ShortTimestampType(int precision) {
        super(precision, Long.TYPE);
        if (precision < 0 || precision > 6) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [0, %s]", 6));
        }
        if (this.getPrecision() == 6) {
            this.range = new Type.Range(Long.MIN_VALUE, Long.MAX_VALUE);
        } else {
            long max = Timestamps.rescale(Timestamps.rescale(Long.MAX_VALUE, 6, this.getPrecision()), this.getPrecision(), 6);
            this.range = new Type.Range(-max, max);
        }
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public final int getFixedSize() {
        return 8;
    }

    @Override
    public final long getLong(Block block, int position) {
        return block.getLong(position, 0);
    }

    @Override
    public final void writeLong(BlockBuilder blockBuilder, long value) {
        ((LongArrayBlockBuilder)blockBuilder).writeLong(value);
    }

    @Override
    public final void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.writeLong(blockBuilder, this.getLong(block, position));
        }
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new LongArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 8));
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 8);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new LongArrayBlockBuilder(null, positionCount);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long epochMicros = this.getLong(block, position);
        return SqlTimestamp.newInstance(this.getPrecision(), epochMicros, 0);
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(this.range);
    }

    @Override
    public Optional<Object> getPreviousValue(Object value) {
        if (((Long)this.range.getMin()).longValue() == ((Long)value).longValue()) {
            return Optional.empty();
        }
        return Optional.of((Long)value - Timestamps.rescale(1000000L, this.getPrecision(), 0));
    }

    @Override
    public Optional<Object> getNextValue(Object value) {
        if (((Long)this.range.getMax()).longValue() == ((Long)value).longValue()) {
            return Optional.empty();
        }
        return Optional.of((Long)value + Timestamps.rescale(1000000L, this.getPrecision(), 0));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(long left, long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(long value) {
        return AbstractLongType.hash(value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(long left, long right) {
        return Long.compare(left, right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(long left, long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(long left, long right) {
        return left <= right;
    }
}

