/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.Int128ArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;

final class LongDecimalType
extends DecimalType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(LongDecimalType.class, MethodHandles.lookup(), Int128.class);

    LongDecimalType(int precision, int scale) {
        super(precision, scale, Int128.class);
        LongDecimalType.checkArgument(18 < precision && precision <= 38, "Invalid precision: %s", precision);
        LongDecimalType.checkArgument(0 <= scale && scale <= precision, "Invalid scale for precision %s: %s", precision, scale);
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public int getFixedSize() {
        return 16;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int128ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int128ArrayBlockBuilder(null, positionCount);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Int128 value = (Int128)this.getObject(block, position);
        BigInteger unscaledValue = value.toBigInteger();
        return new SqlDecimal(unscaledValue, this.getPrecision(), this.getScale());
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(block.getLong(position, 0), block.getLong(position, 8));
        }
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        Int128 decimal = (Int128)value;
        ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(decimal.getHigh(), decimal.getLow());
    }

    @Override
    public Object getObject(Block block, int position) {
        return Int128.valueOf(block.getLong(position, 0), block.getLong(position, 8));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(Int128 left, Int128 right) {
        return left.equals(right);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return leftBlock.getLong(leftPosition, 0) == rightBlock.getLong(rightPosition, 0) && leftBlock.getLong(leftPosition, 8) == rightBlock.getLong(rightPosition, 8);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(Int128 value) {
        return LongDecimalType.xxHash64(value.getHigh(), value.getLow());
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
        return LongDecimalType.xxHash64(block.getLong(position, 0), block.getLong(position, 8));
    }

    private static long xxHash64(long low, long high) {
        return XxHash64.hash((long)low) ^ XxHash64.hash((long)high);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(Int128 left, Int128 right) {
        return left.compareTo(right);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return Int128.compare(leftBlock.getLong(leftPosition, 0), leftBlock.getLong(leftPosition, 8), rightBlock.getLong(rightPosition, 0), rightBlock.getLong(rightPosition, 8));
    }
}

