/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Arrays;

public final class Int128Math {
    private static final int NUMBER_OF_LONGS = 2;
    private static final int NUMBER_OF_INTS = 4;
    private static final Int128[] POWERS_OF_TEN;
    private static final Int128[] POWERS_OF_FIVE;
    private static final long ALL_BITS_SET_64 = -1L;
    private static final long INT_BASE = 0x100000000L;
    private static final long LOW_32_BITS = 0xFFFFFFFFL;
    private static final int MAX_POWER_OF_FIVE_INT = 13;
    private static final int[] POWERS_OF_FIVES_INT;
    private static final int MAX_POWER_OF_FIVE_LONG = 27;
    private static final long[] POWERS_OF_FIVE_LONG;
    private static final int MAX_POWER_OF_TEN_INT = 9;
    private static final int MAX_POWER_OF_TEN_LONG = 18;
    private static final int[] POWERS_OF_TEN_INT;

    public static Int128 powerOfTen(int exponent) {
        return POWERS_OF_TEN[exponent];
    }

    public static void rescale(long high, long low, int factor, long[] result, int offset) {
        if (factor == 0) {
            result[offset] = high;
            result[offset + 1] = low;
        } else if (factor > 0) {
            Int128Math.shiftLeftBy10(high, low, factor, result, offset);
        } else {
            Int128Math.scaleDownRoundUp(high, low, -factor, result, offset);
        }
    }

    public static Int128 rescale(Int128 decimal, int rescaleFactor) {
        long[] result = new long[2];
        Int128Math.rescale(decimal.getHigh(), decimal.getLow(), rescaleFactor, result, 0);
        return Int128.valueOf(result);
    }

    public static void rescaleTruncate(long high, long low, int rescaleFactor, long[] result, int offset) {
        if (rescaleFactor == 0) {
            result[offset] = high;
            result[offset + 1] = low;
        } else if (rescaleFactor > 0) {
            Int128Math.shiftLeftBy10(high, low, rescaleFactor, result, offset);
        } else {
            Int128Math.scaleDownTruncate(high, low, -rescaleFactor, result, offset);
        }
    }

    public static Int128 rescaleTruncate(Int128 decimal, int rescaleFactor) {
        long[] result = new long[2];
        Int128Math.rescaleTruncate(decimal.getHigh(), decimal.getLow(), rescaleFactor, result, 0);
        return Int128.valueOf(result);
    }

    private static void shiftLeftBy10(long high, long low, int rescaleFactor, long[] result, int offset) {
        long tmpLow;
        long tmpHigh;
        boolean negative;
        if (rescaleFactor >= POWERS_OF_TEN.length) {
            throw Int128Math.overflowException();
        }
        boolean bl = negative = high < 0L;
        if (negative) {
            tmpHigh = Int128Math.negateHighExact(high, low);
            tmpLow = Int128Math.negateLowExact(high, low);
            high = tmpHigh;
            low = tmpLow;
        }
        Int128Math.multiplyPositives(high, low, POWERS_OF_TEN[rescaleFactor].getHigh(), POWERS_OF_TEN[rescaleFactor].getLow(), result, offset);
        if (negative) {
            tmpHigh = Int128Math.negateHighExact(result[offset], result[offset + 1]);
            tmpLow = Int128Math.negateLowExact(result[offset], result[offset + 1]);
            result[offset] = tmpHigh;
            result[offset + 1] = tmpLow;
        }
    }

    public static void add(long leftHigh, long leftLow, long rightHigh, long rightLow, long[] result, int offset) {
        long resultHigh;
        long carry = Int128Math.unsignedCarry(leftLow, rightLow);
        long resultLow = leftLow + rightLow;
        result[offset] = resultHigh = leftHigh + rightHigh + carry;
        result[offset + 1] = resultLow;
        if (((resultHigh ^ leftHigh) & (resultHigh ^ rightHigh)) < 0L) {
            throw Int128Math.overflowException();
        }
    }

    public static long addWithOverflow(long leftHigh, long leftLow, long rightHigh, long rightLow, long[] decimal, int offset) {
        long low = leftLow + rightLow;
        long lowCarry = Int128Math.unsignedCarry(leftLow, rightLow);
        long high = leftHigh + rightHigh + lowCarry;
        long overflow = 0L;
        if (leftHigh >= 0L && rightHigh >= 0L && high < 0L) {
            overflow = 1L;
        } else if (leftHigh < 0L && rightHigh < 0L && high >= 0L) {
            overflow = -1L;
        }
        decimal[offset] = high;
        decimal[offset + 1] = low;
        return overflow;
    }

    public static void subtract(long leftHigh, long leftLow, long rightHigh, long rightLow, long[] result, int offset) {
        long borrow = Int128Math.unsignedBorrow(leftLow, rightLow);
        long resultLow = leftLow - rightLow;
        long resultHigh = leftHigh - rightHigh - borrow;
        if (((leftHigh ^ rightHigh) & (leftHigh ^ resultHigh)) < 0L) {
            throw Int128Math.overflowException();
        }
        result[offset] = resultHigh;
        result[offset + 1] = resultLow;
    }

    public static Int128 subtract(Int128 left, Int128 right) {
        long[] result = new long[2];
        Int128Math.subtract(left.getHigh(), left.getLow(), right.getHigh(), right.getLow(), result, 0);
        return Int128.valueOf(result);
    }

    private static long unsignedCarry(long a, long b) {
        return (a >>> 1) + (b >>> 1) + (a & b & 1L) >>> 63;
    }

    private static long unsignedBorrow(long a, long b) {
        return ((a ^ 0xFFFFFFFFFFFFFFFFL) & b | (a ^ b ^ 0xFFFFFFFFFFFFFFFFL) & a - b) >>> 63;
    }

    public static Int128 multiply(Int128 left, Int128 right) {
        return Int128Math.multiply(left.getHigh(), left.getLow(), right.getHigh(), right.getLow());
    }

    private static void multiply(long leftHigh, long leftLow, long rightHigh, long rightLow, long[] result, int offset) {
        long tmpHigh;
        long tmpLow;
        boolean rightNegative;
        boolean leftNegative = leftHigh < 0L;
        boolean bl = rightNegative = rightHigh < 0L;
        if (leftNegative) {
            tmpLow = Int128Math.negateLowExact(leftHigh, leftLow);
            tmpHigh = Int128Math.negateHighExact(leftHigh, leftLow);
            leftLow = tmpLow;
            leftHigh = tmpHigh;
        }
        if (rightNegative) {
            tmpLow = Int128Math.negateLowExact(rightHigh, rightLow);
            tmpHigh = Int128Math.negateHighExact(rightHigh, rightLow);
            rightLow = tmpLow;
            rightHigh = tmpHigh;
        }
        Int128Math.multiplyPositives(leftHigh, leftLow, rightHigh, rightLow, result, offset);
        if (leftNegative != rightNegative) {
            long tmpHigh2 = Int128Math.negateHighExact(result[offset], result[offset + 1]);
            long tmpLow2 = Int128Math.negateLowExact(result[offset], result[offset + 1]);
            result[offset] = tmpHigh2;
            result[offset + 1] = tmpLow2;
        }
    }

    private static void multiplyPositives(long leftHigh, long leftLow, long rightHigh, long rightLow, long[] result, int offset) {
        long z1High = Int128Math.unsignedMultiplyHigh(leftLow, rightLow);
        long z1Low = leftLow * rightLow;
        long z2Low = leftLow * rightHigh;
        long z3Low = leftHigh * rightLow;
        long resultLow = z1Low;
        long resultHigh = z1High + z2Low + z3Low;
        if (leftHigh != 0L && rightHigh != 0L || resultHigh < 0L || z1High < 0L || z2Low < 0L || z3Low < 0L || Int128Math.unsignedMultiplyHigh(leftLow, rightHigh) != 0L || Int128Math.unsignedMultiplyHigh(leftHigh, rightLow) != 0L) {
            throw Int128Math.overflowException();
        }
        result[offset] = resultHigh;
        result[offset + 1] = resultLow;
    }

    public static Int128 multiply(long leftHigh, long leftLow, long rightHigh, long rightLow) {
        long[] result = new long[2];
        Int128Math.multiply(leftHigh, leftLow, rightHigh, rightLow, result, 0);
        return Int128.valueOf(result);
    }

    public static Int128 multiply(Int128 left, long right) {
        return Int128Math.multiply(left.getHigh(), left.getLow(), Int128Math.signExtension(right), right);
    }

    public static Int128 multiply(long left, long right) {
        boolean rightNegative = right < 0L;
        boolean leftNegative = left < 0L;
        left = Math.abs(left);
        right = Math.abs(right);
        long resultLow = left * right;
        long resultHigh = Math.multiplyHigh(left, right);
        if (leftNegative != rightNegative) {
            return Int128.valueOf(Int128Math.negateHighExact(resultHigh, resultLow), Int128Math.negateLowExact(resultHigh, resultLow));
        }
        return Int128.valueOf(resultHigh, resultLow);
    }

    static void multiply256Destructive(int[] left, Int128 right) {
        long accumulator;
        long l0 = Integer.toUnsignedLong(left[0]);
        long l1 = Integer.toUnsignedLong(left[1]);
        long l2 = Integer.toUnsignedLong(left[2]);
        long l3 = Integer.toUnsignedLong(left[3]);
        long r0 = Int128Math.low(right.getLow());
        long r1 = Int128Math.high(right.getLow());
        long r2 = Int128Math.low(right.getHigh());
        long r3 = Int128Math.high(right.getHigh());
        long z0 = 0L;
        long z1 = 0L;
        long z2 = 0L;
        long z3 = 0L;
        long z4 = 0L;
        long z5 = 0L;
        long z6 = 0L;
        long z7 = 0L;
        if (l0 != 0L) {
            accumulator = r0 * l0;
            z0 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r1 * l0;
            z1 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r2 * l0;
            z2 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r3 * l0;
            z3 = Int128Math.low(accumulator);
            z4 = Int128Math.high(accumulator);
        }
        if (l1 != 0L) {
            accumulator = r0 * l1 + z1;
            z1 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r1 * l1 + z2;
            z2 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r2 * l1 + z3;
            z3 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r3 * l1 + z4;
            z4 = Int128Math.low(accumulator);
            z5 = Int128Math.high(accumulator);
        }
        if (l2 != 0L) {
            accumulator = r0 * l2 + z2;
            z2 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r1 * l2 + z3;
            z3 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r2 * l2 + z4;
            z4 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r3 * l2 + z5;
            z5 = Int128Math.low(accumulator);
            z6 = Int128Math.high(accumulator);
        }
        if (l3 != 0L) {
            accumulator = r0 * l3 + z3;
            z3 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r1 * l3 + z4;
            z4 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r2 * l3 + z5;
            z5 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r3 * l3 + z6;
            z6 = Int128Math.low(accumulator);
            z7 = Int128Math.high(accumulator);
        }
        left[0] = (int)z0;
        left[1] = (int)z1;
        left[2] = (int)z2;
        left[3] = (int)z3;
        left[4] = (int)z4;
        left[5] = (int)z5;
        left[6] = (int)z6;
        left[7] = (int)z7;
    }

    static void multiply256Destructive(int[] left, long right) {
        long accumulator;
        long l0 = Integer.toUnsignedLong(left[0]);
        long l1 = Integer.toUnsignedLong(left[1]);
        long l2 = Integer.toUnsignedLong(left[2]);
        long l3 = Integer.toUnsignedLong(left[3]);
        long r0 = Int128Math.low(right);
        long r1 = Int128Math.high(right);
        long z0 = 0L;
        long z1 = 0L;
        long z2 = 0L;
        long z3 = 0L;
        long z4 = 0L;
        long z5 = 0L;
        if (l0 != 0L) {
            accumulator = r0 * l0;
            z0 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r1 * l0;
            z1 = Int128Math.low(accumulator);
            z2 = Int128Math.high(accumulator);
        }
        if (l1 != 0L) {
            accumulator = r0 * l1 + z1;
            z1 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r1 * l1 + z2;
            z2 = Int128Math.low(accumulator);
            z3 = Int128Math.high(accumulator);
        }
        if (l2 != 0L) {
            accumulator = r0 * l2 + z2;
            z2 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r1 * l2 + z3;
            z3 = Int128Math.low(accumulator);
            z4 = Int128Math.high(accumulator);
        }
        if (l3 != 0L) {
            accumulator = r0 * l3 + z3;
            z3 = Int128Math.low(accumulator);
            accumulator = Int128Math.high(accumulator) + r1 * l3 + z4;
            z4 = Int128Math.low(accumulator);
            z5 = Int128Math.high(accumulator);
        }
        left[0] = (int)z0;
        left[1] = (int)z1;
        left[2] = (int)z2;
        left[3] = (int)z3;
        left[4] = (int)z4;
        left[5] = (int)z5;
    }

    static void multiply256Destructive(int[] left, int r0) {
        long l0 = Integer.toUnsignedLong(left[0]);
        long l1 = Integer.toUnsignedLong(left[1]);
        long l2 = Integer.toUnsignedLong(left[2]);
        long l3 = Integer.toUnsignedLong(left[3]);
        long accumulator = (long)r0 * l0;
        long z0 = Int128Math.low(accumulator);
        long z1 = Int128Math.high(accumulator);
        accumulator = (long)r0 * l1 + z1;
        z1 = Int128Math.low(accumulator);
        long z2 = Int128Math.high(accumulator);
        accumulator = (long)r0 * l2 + z2;
        z2 = Int128Math.low(accumulator);
        long z3 = Int128Math.high(accumulator);
        accumulator = (long)r0 * l3 + z3;
        z3 = Int128Math.low(accumulator);
        long z4 = Int128Math.high(accumulator);
        left[0] = (int)z0;
        left[1] = (int)z1;
        left[2] = (int)z2;
        left[3] = (int)z3;
        left[4] = (int)z4;
    }

    public static int compareAbsolute(Int128 left, Int128 right) {
        long rightLow;
        long rightHigh;
        long leftHigh = left.getHigh();
        if (leftHigh != (rightHigh = right.getHigh())) {
            return Long.compareUnsigned(leftHigh, rightHigh);
        }
        long leftLow = left.getLow();
        if (leftLow != (rightLow = right.getLow())) {
            return Long.compareUnsigned(leftLow, rightLow);
        }
        return 0;
    }

    public static int compareAbsolute(long leftLow, long leftHigh, long rightLow, long rightHigh) {
        if (leftHigh != rightHigh) {
            return Long.compareUnsigned(leftHigh, rightHigh);
        }
        if (leftLow != rightLow) {
            return Long.compareUnsigned(leftLow, rightLow);
        }
        return 0;
    }

    private static long incrementLow(long unusedHigh, long low) {
        return low + 1L;
    }

    private static long incrementHigh(long high, long low) {
        return high + (long)(low == -1L ? 1 : 0);
    }

    private static long decrementLow(long unusedHigh, long low) {
        return low - 1L;
    }

    private static long decrementHigh(long high, long low) {
        return high - (long)(low == 0L ? 1 : 0);
    }

    private static void incrementUnsafe(long[] value, int offset) {
        long high = value[offset];
        long low = value[offset + 1];
        value[offset] = Int128Math.incrementHigh(high, low);
        value[offset + 1] = Int128Math.incrementLow(high, low);
    }

    private static void decrementUnsafe(long[] value, int offset) {
        long high = value[offset];
        long low = value[offset + 1];
        value[offset] = Int128Math.decrementHigh(high, low);
        value[offset + 1] = Int128Math.decrementLow(high, low);
    }

    public static Int128 absExact(Int128 value) {
        if (value.isNegative()) {
            return Int128Math.negateExact(value);
        }
        return value;
    }

    public static Int128 negate(Int128 value) {
        return Int128.valueOf(Int128Math.negateHigh(value.getHigh(), value.getLow()), Int128Math.negateLow(value.getHigh(), value.getLow()));
    }

    public static Int128 negateExact(Int128 value) {
        return Int128.valueOf(Int128Math.negateHighExact(value.getHigh(), value.getLow()), Int128Math.negateLowExact(value.getHigh(), value.getLow()));
    }

    private static void negate(long[] value, int offset) {
        long high = value[offset];
        long low = value[offset + 1];
        value[offset] = Int128Math.negateHigh(high, low);
        value[offset + 1] = Int128Math.negateLow(high, low);
    }

    private static long negateHighExact(long high, long low) {
        if (high == Int128.MIN_VALUE.getHigh() && low == Int128.MIN_VALUE.getLow()) {
            throw new ArithmeticException("Overflow");
        }
        return Int128Math.negateHigh(high, low);
    }

    private static long negateHigh(long high, long low) {
        return -high - (long)(low != 0L ? 1 : 0);
    }

    private static long negateLow(long unusedHigh, long low) {
        return -low;
    }

    private static long negateLowExact(long high, long low) {
        return Int128Math.negateLow(high, low);
    }

    private static void scaleDownRoundUp(long high, long low, int scaleFactor, long[] result, int offset) {
        if (scaleFactor <= 18 && high == 0L && low >= 0L) {
            long divisor = Decimals.longTenToNth(scaleFactor);
            long newLow = low / divisor;
            if (low % divisor >= divisor >> 1) {
                // empty if block
            }
            result[offset] = 0L;
            result[offset + 1] = ++newLow;
            return;
        }
        Int128Math.scaleDown(high, low, scaleFactor, result, offset, true);
    }

    private static void scaleDownTruncate(long high, long low, int scaleFactor, long[] result, int offset) {
        if (scaleFactor <= 18 && high == 0L && low >= 0L) {
            long divisor = Decimals.longTenToNth(scaleFactor);
            long newLow = low / divisor;
            result[offset] = 0L;
            result[offset + 1] = newLow;
            return;
        }
        Int128Math.scaleDown(high, low, scaleFactor, result, offset, false);
    }

    private static void scaleDown(long high, long low, int scaleFactor, long[] result, int offset, boolean roundUp) {
        boolean negative;
        boolean bl = negative = high < 0L;
        if (negative) {
            long tmpLow = Int128Math.negateLowExact(high, low);
            long tmpHigh = Int128Math.negateHighExact(high, low);
            low = tmpLow;
            high = tmpHigh;
        }
        if ((scaleFactor - 1) / 13 < (scaleFactor - 1) / 9) {
            Int128Math.scaleDownFive(high, low, scaleFactor, result, offset);
            Int128Math.shiftRight(result[offset], result[offset + 1], scaleFactor, roundUp, result, offset);
        } else {
            Int128Math.scaleDownTen(high, low, scaleFactor, result, offset, roundUp);
        }
        if (negative) {
            Int128Math.negate(result, offset);
        }
    }

    private static void scaleDownFive(long high, long low, int fiveScale, long[] result, int offset) {
        if (high < 0L) {
            throw new IllegalArgumentException("Value must be positive");
        }
        while (true) {
            int powerFive = Math.min(fiveScale, 13);
            int divisor = POWERS_OF_FIVES_INT[powerFive];
            Int128Math.dividePositives(high, low, divisor, result, offset);
            if ((fiveScale -= powerFive) == 0) {
                return;
            }
            high = result[offset];
            low = result[offset + 1];
        }
    }

    private static void scaleDownTen(long high, long low, int tenScale, long[] result, int offset, boolean roundUp) {
        boolean needsRounding;
        int powerTen;
        if (high < 0L) {
            throw new IllegalArgumentException("Value must be positive");
        }
        do {
            powerTen = Math.min(tenScale, 9);
            int divisor = POWERS_OF_TEN_INT[powerTen];
            needsRounding = Int128Math.divideCheckRound(high, low, divisor, result, offset);
            high = result[offset];
            low = result[offset + 1];
        } while ((tenScale -= powerTen) > 0);
        if (roundUp && needsRounding) {
            Int128Math.incrementUnsafe(result, offset);
        }
    }

    static void shiftRight(long high, long low, int shift, boolean roundUp, long[] result, int offset) {
        boolean needsRounding;
        if (high < 0L) {
            throw new IllegalArgumentException("Value must be positive");
        }
        if (shift == 0) {
            return;
        }
        if (shift < 64) {
            needsRounding = roundUp && (low & 1L << shift - 1) != 0L;
            low = high << 1 << 63 - shift | low >>> shift;
            high >>= shift;
        } else {
            needsRounding = roundUp && (high & 1L << shift - 64 - 1) != 0L;
            low = high >> shift - 64;
            high = 0L;
        }
        if (needsRounding) {
            long tmpHigh = Int128Math.incrementHigh(high, low);
            long tmpLow = Int128Math.incrementLow(high, low);
            high = tmpHigh;
            low = tmpLow;
        }
        result[offset] = high;
        result[offset + 1] = low;
    }

    public static Int128 floorDiv(Int128 dividend, Int128 divisor) {
        return Int128Math.floorDiv(dividend.getHigh(), dividend.getLow(), divisor.getHigh(), divisor.getLow());
    }

    private static Int128 floorDiv(long dividendHigh, long dividendLow, long divisorHigh, long divisorLow) {
        long tmpHigh;
        long tmpLow;
        boolean quotientIsNegative;
        long[] quotient = new long[2];
        long[] remainder = new long[2];
        boolean dividendIsNegative = dividendHigh < 0L;
        boolean divisorIsNegative = divisorHigh < 0L;
        boolean bl = quotientIsNegative = dividendIsNegative != divisorIsNegative;
        if (dividendIsNegative) {
            tmpLow = Int128Math.negateLowExact(dividendHigh, dividendLow);
            tmpHigh = Int128Math.negateHighExact(dividendHigh, dividendLow);
            dividendLow = tmpLow;
            dividendHigh = tmpHigh;
        }
        if (divisorIsNegative) {
            tmpLow = Int128Math.negateLowExact(divisorHigh, divisorLow);
            tmpHigh = Int128Math.negateHighExact(divisorHigh, divisorLow);
            divisorLow = tmpLow;
            divisorHigh = tmpHigh;
        }
        Int128Math.dividePositives(dividendHigh, dividendLow, 0, divisorHigh, divisorLow, 0, quotient, remainder);
        if (quotientIsNegative) {
            Int128Math.negate(quotient, 0);
            if (remainder[0] != 0L || remainder[1] != 0L) {
                Int128Math.decrementUnsafe(quotient, 0);
            }
        }
        return Int128.valueOf(quotient);
    }

    public static Int128 divideRoundUp(long dividendHigh, long dividendLow, int dividendScaleFactor, long divisorHigh, long divisorLow, int divisorScaleFactor) {
        long tmpHigh;
        long tmpLow;
        boolean quotientIsNegative;
        if (dividendScaleFactor >= 38) {
            throw Int128Math.overflowException();
        }
        if (divisorScaleFactor >= 38) {
            throw Int128Math.overflowException();
        }
        long[] quotient = new long[2];
        long[] remainder = new long[2];
        boolean dividendIsNegative = dividendHigh < 0L;
        boolean divisorIsNegative = divisorHigh < 0L;
        boolean bl = quotientIsNegative = dividendIsNegative != divisorIsNegative;
        if (dividendIsNegative) {
            tmpLow = Int128Math.negateLowExact(dividendHigh, dividendLow);
            tmpHigh = Int128Math.negateHighExact(dividendHigh, dividendLow);
            dividendLow = tmpLow;
            dividendHigh = tmpHigh;
        }
        if (divisorIsNegative) {
            tmpLow = Int128Math.negateLowExact(divisorHigh, divisorLow);
            tmpHigh = Int128Math.negateHighExact(divisorHigh, divisorLow);
            divisorLow = tmpLow;
            divisorHigh = tmpHigh;
        }
        Int128Math.dividePositives(dividendHigh, dividendLow, dividendScaleFactor, divisorHigh, divisorLow, divisorScaleFactor, quotient, remainder);
        Int128Math.shiftLeft(remainder, 1);
        long remainderLow = remainder[1];
        long remainderHigh = remainder[0];
        if (Int128Math.compareUnsigned(remainderHigh, remainderLow, divisorHigh, divisorLow) >= 0) {
            Int128Math.incrementUnsafe(quotient, 0);
        }
        if (quotientIsNegative) {
            Int128Math.negate(quotient, 0);
        }
        return Int128.valueOf(quotient);
    }

    public static void shiftLeft(long[] decimal, int shift) {
        long high = decimal[0];
        long low = decimal[1];
        if (shift < 64) {
            high = high << shift | low >>> 1 >>> 63 - shift;
            low <<= shift;
        } else {
            high = low << shift - 64;
            low = 0L;
        }
        decimal[0] = high;
        decimal[1] = low;
    }

    public static Int128 remainder(long dividendHigh, long dividendLow, int dividendScaleFactor, long divisorHigh, long divisorLow, int divisorScaleFactor) {
        long tmpHigh;
        long tmpLow;
        boolean divisorIsNegative;
        long[] quotient = new long[2];
        long[] remainder = new long[2];
        boolean dividendIsNegative = dividendHigh < 0L;
        boolean bl = divisorIsNegative = divisorHigh < 0L;
        if (dividendIsNegative) {
            tmpLow = Int128Math.negateLowExact(dividendHigh, dividendLow);
            tmpHigh = Int128Math.negateHighExact(dividendHigh, dividendLow);
            dividendLow = tmpLow;
            dividendHigh = tmpHigh;
        }
        if (divisorIsNegative) {
            tmpLow = Int128Math.negateLowExact(divisorHigh, divisorLow);
            tmpHigh = Int128Math.negateHighExact(divisorHigh, divisorLow);
            divisorLow = tmpLow;
            divisorHigh = tmpHigh;
        }
        Int128Math.dividePositives(dividendHigh, dividendLow, dividendScaleFactor, divisorHigh, divisorLow, divisorScaleFactor, quotient, remainder);
        if (dividendIsNegative) {
            Int128Math.negate(remainder, 0);
        }
        return Int128.valueOf(remainder);
    }

    private static void dividePositives(long dividendHigh, long dividendLow, int dividendScaleFactor, long divisorHigh, long divisorLow, int divisorScaleFactor, long[] quotient, long[] remainder) {
        if (divisorHigh == 0L && divisorLow == 0L) {
            throw Int128Math.divisionByZeroException();
        }
        int[] dividend = new int[9];
        dividend[0] = Int128Math.lowInt(dividendLow);
        dividend[1] = Int128Math.highInt(dividendLow);
        dividend[2] = Int128Math.lowInt(dividendHigh);
        dividend[3] = Int128Math.highInt(dividendHigh);
        if (dividendScaleFactor > 0) {
            Int128Math.shiftLeftBy5Destructive(dividend, dividendScaleFactor);
            Int128Math.shiftLeftMultiPrecision(dividend, 8, dividendScaleFactor);
        }
        int[] divisor = new int[8];
        divisor[0] = Int128Math.lowInt(divisorLow);
        divisor[1] = Int128Math.highInt(divisorLow);
        divisor[2] = Int128Math.lowInt(divisorHigh);
        divisor[3] = Int128Math.highInt(divisorHigh);
        if (divisorScaleFactor > 0) {
            Int128Math.shiftLeftBy5Destructive(divisor, divisorScaleFactor);
            Int128Math.shiftLeftMultiPrecision(divisor, 8, divisorScaleFactor);
        }
        int[] multiPrecisionQuotient = new int[8];
        Int128Math.divideUnsignedMultiPrecision(dividend, divisor, multiPrecisionQuotient);
        Int128Math.pack(multiPrecisionQuotient, quotient);
        Int128Math.pack(dividend, remainder);
    }

    private static void shiftLeftBy5Destructive(int[] value, int shift) {
        if (shift <= 13) {
            Int128Math.multiply256Destructive(value, POWERS_OF_FIVES_INT[shift]);
        } else if (shift < 18) {
            Int128Math.multiply256Destructive(value, POWERS_OF_FIVE_LONG[shift]);
        } else {
            Int128Math.multiply256Destructive(value, POWERS_OF_FIVE[shift]);
        }
    }

    private static void divideUnsignedMultiPrecision(int[] dividend, int[] divisor, int[] quotient) {
        Int128Math.checkArgument(dividend.length == 9);
        Int128Math.checkArgument(divisor.length == 8);
        Int128Math.checkArgument(quotient.length == 8);
        int divisorLength = Int128Math.digitsInIntegerBase(divisor);
        int dividendLength = Int128Math.digitsInIntegerBase(dividend);
        if (dividendLength < divisorLength) {
            return;
        }
        if (divisorLength == 1) {
            int remainder = Int128Math.divideUnsignedMultiPrecision(dividend, dividendLength, divisor[0]);
            Int128Math.checkState(dividend[dividend.length - 1] == 0);
            System.arraycopy(dividend, 0, quotient, 0, quotient.length);
            Arrays.fill(dividend, 0);
            dividend[0] = remainder;
            return;
        }
        int nlz = Integer.numberOfLeadingZeros(divisor[divisorLength - 1]);
        Int128Math.shiftLeftMultiPrecision(divisor, divisorLength, nlz);
        int normalizedDividendLength = Math.min(dividend.length, dividendLength + 1);
        Int128Math.shiftLeftMultiPrecision(dividend, normalizedDividendLength, nlz);
        Int128Math.divideKnuthNormalized(dividend, normalizedDividendLength, divisor, divisorLength, quotient);
        Int128Math.shiftRightMultiPrecision(dividend, normalizedDividendLength, nlz);
    }

    private static void divideKnuthNormalized(int[] remainder, int dividendLength, int[] divisor, int divisorLength, int[] quotient) {
        int v1 = divisor[divisorLength - 1];
        int v0 = divisor[divisorLength - 2];
        for (int reminderIndex = dividendLength - 1; reminderIndex >= divisorLength; --reminderIndex) {
            boolean overflow;
            int qHat = Int128Math.estimateQuotient(remainder[reminderIndex], remainder[reminderIndex - 1], remainder[reminderIndex - 2], v1, v0);
            if (qHat != 0 && (overflow = Int128Math.multiplyAndSubtractUnsignedMultiPrecision(remainder, reminderIndex, divisor, divisorLength, qHat))) {
                Int128Math.addUnsignedMultiPrecision(remainder, reminderIndex, divisor, divisorLength);
            }
            quotient[reminderIndex - divisorLength] = --qHat;
        }
    }

    private static int estimateQuotient(int u2, int u1, int u0, int v1, int v0) {
        long u21 = Int128Math.combineInts(u2, u1);
        long qhat = u2 == v1 ? 0xFFFFFFFFL : (u21 >= 0L ? u21 / Integer.toUnsignedLong(v1) : Int128Math.divideUnsignedLong(u21, v1));
        if (qhat == 0L) {
            return 0;
        }
        int iterations = 0;
        long rhat = u21 - Integer.toUnsignedLong(v1) * qhat;
        while (Long.compareUnsigned(rhat, 0x100000000L) < 0 && Long.compareUnsigned(Integer.toUnsignedLong(v0) * qhat, Int128Math.combineInts(Int128Math.lowInt(rhat), u0)) > 0) {
            ++iterations;
            --qhat;
            rhat += Integer.toUnsignedLong(v1);
        }
        if (iterations > 2) {
            throw new IllegalStateException("qhat is greater than q by more than 2: " + iterations);
        }
        return (int)qhat;
    }

    private static long divideUnsignedLong(long dividend, int divisor) {
        long unsignedDivisor = Integer.toUnsignedLong(divisor);
        if (dividend > 0L) {
            return dividend / unsignedDivisor;
        }
        long quotient = (dividend >>> 1) / unsignedDivisor * 2L;
        long remainder = dividend - quotient * unsignedDivisor;
        if (Long.compareUnsigned(remainder, unsignedDivisor) >= 0) {
            ++quotient;
        }
        return quotient;
    }

    private static boolean multiplyAndSubtractUnsignedMultiPrecision(int[] left, int leftOffset, int[] right, int length, int multiplier) {
        long unsignedMultiplier = Integer.toUnsignedLong(multiplier);
        int leftIndex = leftOffset - length;
        long multiplyAccumulator = 0L;
        long subtractAccumulator = 0x100000000L;
        int rightIndex = 0;
        while (rightIndex < length) {
            multiplyAccumulator = Integer.toUnsignedLong(right[rightIndex]) * unsignedMultiplier + multiplyAccumulator;
            subtractAccumulator = subtractAccumulator + Integer.toUnsignedLong(left[leftIndex]) - Integer.toUnsignedLong(Int128Math.lowInt(multiplyAccumulator));
            multiplyAccumulator = Int128Math.high(multiplyAccumulator);
            left[leftIndex] = Int128Math.lowInt(subtractAccumulator);
            subtractAccumulator = Int128Math.high(subtractAccumulator) + 0x100000000L - 1L;
            ++rightIndex;
            ++leftIndex;
        }
        left[leftIndex] = Int128Math.lowInt(subtractAccumulator += Integer.toUnsignedLong(left[leftIndex]) - multiplyAccumulator);
        return Int128Math.highInt(subtractAccumulator) == 0;
    }

    private static void addUnsignedMultiPrecision(int[] left, int leftOffset, int[] right, int length) {
        int leftIndex = leftOffset - length;
        int carry = 0;
        int rightIndex = 0;
        while (rightIndex < length) {
            long accumulator = Integer.toUnsignedLong(left[leftIndex]) + Integer.toUnsignedLong(right[rightIndex]) + Integer.toUnsignedLong(carry);
            left[leftIndex] = Int128Math.lowInt(accumulator);
            carry = Int128Math.highInt(accumulator);
            ++rightIndex;
            ++leftIndex;
        }
        int n = leftIndex;
        left[n] = left[n] + carry;
    }

    static int[] shiftLeftMultiPrecision(int[] number, int length, int shifts) {
        int bitShifts;
        if (shifts == 0) {
            return number;
        }
        int wordShifts = shifts >>> 5;
        for (int i = 0; i < wordShifts; ++i) {
            Int128Math.checkState(number[length - i - 1] == 0);
        }
        if (wordShifts > 0) {
            System.arraycopy(number, 0, number, wordShifts, length - wordShifts);
            Arrays.fill(number, 0, wordShifts, 0);
        }
        if ((bitShifts = shifts & 0x1F) > 0) {
            Int128Math.checkState(number[length - 1] >>> 32 - bitShifts == 0);
            for (int position = length - 1; position > 0; --position) {
                number[position] = number[position] << bitShifts | number[position - 1] >>> 32 - bitShifts;
            }
            number[0] = number[0] << bitShifts;
        }
        return number;
    }

    static int[] shiftRightMultiPrecision(int[] number, int length, int shifts) {
        int bitShifts;
        if (shifts == 0) {
            return number;
        }
        int wordShifts = shifts >>> 5;
        for (int i = 0; i < wordShifts; ++i) {
            Int128Math.checkState(number[i] == 0);
        }
        if (wordShifts > 0) {
            System.arraycopy(number, wordShifts, number, 0, length - wordShifts);
            Arrays.fill(number, length - wordShifts, length, 0);
        }
        if ((bitShifts = shifts & 0x1F) > 0) {
            Int128Math.checkState(number[0] << 32 - bitShifts == 0);
            for (int position = 0; position < length - 1; ++position) {
                number[position] = number[position] >>> bitShifts | number[position + 1] << 32 - bitShifts;
            }
            number[length - 1] = number[length - 1] >>> bitShifts;
        }
        return number;
    }

    private static int divideUnsignedMultiPrecision(int[] dividend, int dividendLength, int divisor) {
        if (divisor == 0) {
            throw Int128Math.divisionByZeroException();
        }
        if (dividendLength == 1) {
            long dividendUnsigned = Integer.toUnsignedLong(dividend[0]);
            long divisorUnsigned = Integer.toUnsignedLong(divisor);
            long quotient = dividendUnsigned / divisorUnsigned;
            long remainder = dividendUnsigned - divisorUnsigned * quotient;
            dividend[0] = (int)quotient;
            return (int)remainder;
        }
        long divisorUnsigned = Integer.toUnsignedLong(divisor);
        long remainder = 0L;
        for (int dividendIndex = dividendLength - 1; dividendIndex >= 0; --dividendIndex) {
            remainder = (remainder << 32) + Integer.toUnsignedLong(dividend[dividendIndex]);
            long quotient = Int128Math.divideUnsignedLong(remainder, divisor);
            dividend[dividendIndex] = (int)quotient;
            remainder -= quotient * divisorUnsigned;
        }
        return (int)remainder;
    }

    private static int digitsInIntegerBase(int[] digits) {
        int length;
        for (length = digits.length; length > 0 && digits[length - 1] == 0; --length) {
        }
        return length;
    }

    private static long combineInts(int high, int low) {
        return (long)high << 32 | Integer.toUnsignedLong(low);
    }

    private static long high(long value) {
        return value >>> 32;
    }

    private static long low(long value) {
        return value & 0xFFFFFFFFL;
    }

    private static int highInt(long val) {
        return (int)Int128Math.high(val);
    }

    private static int lowInt(long val) {
        return (int)val;
    }

    private static boolean divideCheckRound(long dividendHigh, long dividendLow, int divisor, long[] result, int offset) {
        int remainder = Int128Math.dividePositives(dividendHigh, dividendLow, divisor, result, offset);
        return remainder >= divisor >> 1;
    }

    private static int dividePositives(long dividendHigh, long dividendLow, int divisor, long[] result, int offset) {
        long remainder = dividendHigh;
        long high = remainder / (long)divisor;
        remainder %= (long)divisor;
        remainder = Int128Math.high(dividendLow) + (remainder << 32);
        int z1 = (int)(remainder / (long)divisor);
        remainder %= (long)divisor;
        remainder = Int128Math.low(dividendLow) + (remainder << 32);
        int z0 = (int)(remainder / (long)divisor);
        long low = (long)z1 << 32 | (long)z0 & 0xFFFFFFFFL;
        result[offset] = high;
        result[offset + 1] = low;
        return (int)(remainder % (long)divisor);
    }

    private static void pack(int[] parts, long[] result) {
        long high = (long)parts[3] << 32 | (long)parts[2] & 0xFFFFFFFFL;
        long low = (long)parts[1] << 32 | (long)parts[0] & 0xFFFFFFFFL;
        if (parts[4] != 0 || parts[5] != 0 || parts[6] != 0 || parts[7] != 0) {
            throw new ArithmeticException("Overflow");
        }
        result[0] = high;
        result[1] = low;
    }

    private static long signExtension(long value) {
        return value >> 63;
    }

    private static long unsignedMultiplyHigh(long x, long y) {
        long result = Math.multiplyHigh(x, y);
        result += y & x >> 63;
        return result += x & y >> 63;
    }

    private static int compareUnsigned(long leftHigh, long leftLow, long rightHigh, long rightLow) {
        int comparison = Long.compareUnsigned(leftHigh, rightHigh);
        if (comparison == 0) {
            comparison = Long.compareUnsigned(leftLow, rightLow);
        }
        return comparison;
    }

    private static ArithmeticException overflowException() {
        return new ArithmeticException("Overflow");
    }

    private static ArithmeticException divisionByZeroException() {
        return new ArithmeticException("Division by zero");
    }

    private static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    private static void checkState(boolean condition) {
        if (!condition) {
            throw new IllegalStateException();
        }
    }

    private Int128Math() {
    }

    static {
        int i;
        POWERS_OF_TEN = new Int128[39];
        POWERS_OF_FIVE = new Int128[54];
        POWERS_OF_FIVES_INT = new int[14];
        POWERS_OF_FIVE_LONG = new long[28];
        POWERS_OF_TEN_INT = new int[10];
        for (i = 0; i < POWERS_OF_FIVE.length; ++i) {
            Int128Math.POWERS_OF_FIVE[i] = Int128.valueOf(BigInteger.valueOf(5L).pow(i));
        }
        for (i = 0; i < POWERS_OF_TEN.length; ++i) {
            Int128Math.POWERS_OF_TEN[i] = Int128.valueOf(BigInteger.TEN.pow(i));
        }
        Int128Math.POWERS_OF_FIVES_INT[0] = 1;
        for (i = 1; i < POWERS_OF_FIVES_INT.length; ++i) {
            Int128Math.POWERS_OF_FIVES_INT[i] = POWERS_OF_FIVES_INT[i - 1] * 5;
        }
        Int128Math.POWERS_OF_FIVE_LONG[0] = 1L;
        for (i = 1; i < POWERS_OF_FIVE_LONG.length; ++i) {
            Int128Math.POWERS_OF_FIVE_LONG[i] = POWERS_OF_FIVE_LONG[i - 1] * 5L;
        }
        Int128Math.POWERS_OF_TEN_INT[0] = 1;
        for (i = 1; i < POWERS_OF_TEN_INT.length; ++i) {
            Int128Math.POWERS_OF_TEN_INT[i] = POWERS_OF_TEN_INT[i - 1] * 10;
        }
        if (!ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            throw new IllegalStateException("UnsignedDecimal128Arithmetic is supported on little-endian machines only");
        }
    }
}

