/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class BigintType
extends AbstractLongType {
    public static final BigintType BIGINT = new BigintType();

    private BigintType() {
        super(new TypeSignature("bigint", new TypeSignatureParameter[0]));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getLong(position, 0);
    }

    @Override
    public boolean equals(Object other) {
        return other == BIGINT;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(new Type.Range(Long.MIN_VALUE, Long.MAX_VALUE));
    }

    @Override
    public Optional<Object> getPreviousValue(Object object) {
        long value = (Long)object;
        if (value == Long.MIN_VALUE) {
            return Optional.empty();
        }
        return Optional.of(value - 1L);
    }

    @Override
    public Optional<Object> getNextValue(Object object) {
        long value = (Long)object;
        if (value == Long.MAX_VALUE) {
            return Optional.empty();
        }
        return Optional.of(value + 1L);
    }

    @Override
    public Optional<Stream<?>> getDiscreteValues(Type.Range range) {
        return Optional.of(LongStream.rangeClosed((Long)range.getMin(), (Long)range.getMax()).boxed());
    }
}

