/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.block.AbstractArrayBlock;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorMethodHandle;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

public class ArrayType
extends AbstractType {
    private static final InvocationConvention EQUAL_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention HASH_CODE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention DISTINCT_FROM_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE);
    private static final InvocationConvention INDETERMINATE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NULL_FLAG);
    private static final InvocationConvention COMPARISON_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final MethodHandle EQUAL;
    private static final MethodHandle HASH_CODE;
    private static final MethodHandle DISTINCT_FROM;
    private static final MethodHandle INDETERMINATE;
    private static final MethodHandle COMPARISON;
    private static final String ARRAY_NULL_ELEMENT_MSG = "ARRAY comparison not supported for arrays with null elements";
    private final Type elementType;
    private volatile TypeOperatorDeclaration operatorDeclaration;

    public ArrayType(Type elementType) {
        super(new TypeSignature("array", TypeSignatureParameter.typeParameter(elementType.getTypeSignature())), Block.class);
        this.elementType = Objects.requireNonNull(elementType, "elementType is null");
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        if (this.operatorDeclaration == null) {
            this.generateTypeOperators(typeOperators);
        }
        return this.operatorDeclaration;
    }

    private synchronized void generateTypeOperators(TypeOperators typeOperators) {
        if (this.operatorDeclaration != null) {
            return;
        }
        this.operatorDeclaration = TypeOperatorDeclaration.builder(this.getJavaType()).addEqualOperators(ArrayType.getEqualOperatorMethodHandles(typeOperators, this.elementType)).addHashCodeOperators(ArrayType.getHashCodeOperatorMethodHandles(typeOperators, this.elementType)).addXxHash64Operators(ArrayType.getXxHash64OperatorMethodHandles(typeOperators, this.elementType)).addDistinctFromOperators(ArrayType.getDistinctFromOperatorInvokers(typeOperators, this.elementType)).addIndeterminateOperators(ArrayType.getIndeterminateOperatorInvokers(typeOperators, this.elementType)).addComparisonUnorderedLastOperators(ArrayType.getComparisonOperatorInvokers(typeOperators::getComparisonUnorderedLastOperator, this.elementType)).addComparisonUnorderedFirstOperators(ArrayType.getComparisonOperatorInvokers(typeOperators::getComparisonUnorderedFirstOperator, this.elementType)).build();
    }

    private static List<OperatorMethodHandle> getEqualOperatorMethodHandles(TypeOperators typeOperators, Type elementType) {
        if (!elementType.isComparable()) {
            return Collections.emptyList();
        }
        MethodHandle equalOperator = typeOperators.getEqualOperator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(EQUAL_CONVENTION, EQUAL.bindTo(equalOperator)));
    }

    private static List<OperatorMethodHandle> getHashCodeOperatorMethodHandles(TypeOperators typeOperators, Type elementType) {
        if (!elementType.isComparable()) {
            return Collections.emptyList();
        }
        MethodHandle elementHashCodeOperator = typeOperators.getHashCodeOperator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(HASH_CODE_CONVENTION, HASH_CODE.bindTo(elementHashCodeOperator)));
    }

    private static List<OperatorMethodHandle> getXxHash64OperatorMethodHandles(TypeOperators typeOperators, Type elementType) {
        if (!elementType.isComparable()) {
            return Collections.emptyList();
        }
        MethodHandle elementHashCodeOperator = typeOperators.getXxHash64Operator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(HASH_CODE_CONVENTION, HASH_CODE.bindTo(elementHashCodeOperator)));
    }

    private static List<OperatorMethodHandle> getDistinctFromOperatorInvokers(TypeOperators typeOperators, Type elementType) {
        if (!elementType.isComparable()) {
            return Collections.emptyList();
        }
        MethodHandle elementDistinctFromOperator = typeOperators.getDistinctFromOperator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        return Collections.singletonList(new OperatorMethodHandle(DISTINCT_FROM_CONVENTION, DISTINCT_FROM.bindTo(elementDistinctFromOperator)));
    }

    private static List<OperatorMethodHandle> getIndeterminateOperatorInvokers(TypeOperators typeOperators, Type elementType) {
        if (!elementType.isComparable()) {
            return Collections.emptyList();
        }
        MethodHandle elementIndeterminateOperator = typeOperators.getIndeterminateOperator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(INDETERMINATE_CONVENTION, INDETERMINATE.bindTo(elementIndeterminateOperator)));
    }

    private static List<OperatorMethodHandle> getComparisonOperatorInvokers(BiFunction<Type, InvocationConvention, MethodHandle> comparisonOperatorFactory, Type elementType) {
        if (!elementType.isOrderable()) {
            return Collections.emptyList();
        }
        MethodHandle elementComparisonOperator = comparisonOperatorFactory.apply(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(COMPARISON_CONVENTION, COMPARISON.bindTo(elementComparisonOperator)));
    }

    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isComparable() {
        return this.elementType.isComparable();
    }

    @Override
    public boolean isOrderable() {
        return this.elementType.isOrderable();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (block instanceof AbstractArrayBlock) {
            return ((AbstractArrayBlock)block).apply((valuesBlock, start, length) -> this.arrayBlockToObjectValues(session, valuesBlock, start, length), position);
        }
        Block arrayBlock = block.getObject(position, Block.class);
        return this.arrayBlockToObjectValues(session, arrayBlock, 0, arrayBlock.getPositionCount());
    }

    private List<Object> arrayBlockToObjectValues(ConnectorSession session, Block block, int start, int length) {
        ArrayList<Object> values = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            values.add(this.elementType.getObjectValue(session, block, i + start));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.writeObject(blockBuilder, this.getObject(block, position));
        }
    }

    @Override
    public Block getObject(Block block, int position) {
        return block.getObject(position, Block.class);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        Block arrayBlock = (Block)value;
        ((ArrayBlockBuilder)blockBuilder).buildEntry(elementBuilder -> {
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                this.elementType.appendTo(arrayBlock, i, elementBuilder);
            }
        });
    }

    @Override
    public ArrayBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new ArrayBlockBuilder(this.elementType, blockBuilderStatus, expectedEntries, expectedBytesPerEntry);
    }

    @Override
    public ArrayBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 100);
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.singletonList(this.getElementType());
    }

    @Override
    public String getDisplayName() {
        return "array(" + this.elementType.getDisplayName() + ")";
    }

    private static Boolean equalOperator(MethodHandle equalOperator, Block leftArray, Block rightArray) throws Throwable {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        boolean unknown = false;
        for (int position = 0; position < leftArray.getPositionCount(); ++position) {
            if (leftArray.isNull(position) || rightArray.isNull(position)) {
                unknown = true;
                continue;
            }
            Boolean result = equalOperator.invokeExact(leftArray, position, rightArray, position);
            if (result == null) {
                unknown = true;
                continue;
            }
            if (result.booleanValue()) continue;
            return false;
        }
        if (unknown) {
            return null;
        }
        return true;
    }

    private static long hashOperator(MethodHandle hashOperator, Block block) throws Throwable {
        long hash = 0L;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            long elementHash = block.isNull(position) ? 0L : hashOperator.invokeExact(block, position);
            hash = 31L * hash + elementHash;
        }
        return hash;
    }

    private static boolean distinctFromOperator(MethodHandle distinctFromOperator, Block leftArray, Block rightArray) throws Throwable {
        boolean rightIsNull;
        boolean leftIsNull = leftArray == null;
        boolean bl = rightIsNull = rightArray == null;
        if (leftIsNull || rightIsNull) {
            return leftIsNull != rightIsNull;
        }
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return true;
        }
        for (int position = 0; position < leftArray.getPositionCount(); ++position) {
            boolean result = distinctFromOperator.invokeExact(leftArray, position, rightArray, position);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private static boolean indeterminateOperator(MethodHandle elementIndeterminateFunction, Block block, boolean isNull) throws Throwable {
        if (isNull) {
            return true;
        }
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                return true;
            }
            if (!elementIndeterminateFunction.invoke(block, position)) continue;
            return true;
        }
        return false;
    }

    private static long comparisonOperator(MethodHandle comparisonOperator, Block leftArray, Block rightArray) throws Throwable {
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int position = 0; position < len; ++position) {
            TypeUtils.checkElementNotNull(leftArray.isNull(position), ARRAY_NULL_ELEMENT_MSG);
            TypeUtils.checkElementNotNull(rightArray.isNull(position), ARRAY_NULL_ELEMENT_MSG);
            long result = comparisonOperator.invokeExact(leftArray, position, rightArray, position);
            if (result == 0L) continue;
            return result;
        }
        return Integer.compare(leftArray.getPositionCount(), rightArray.getPositionCount());
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            EQUAL = lookup.findStatic(ArrayType.class, "equalOperator", MethodType.methodType(Boolean.class, MethodHandle.class, Block.class, Block.class));
            HASH_CODE = lookup.findStatic(ArrayType.class, "hashOperator", MethodType.methodType(Long.TYPE, MethodHandle.class, Block.class));
            DISTINCT_FROM = lookup.findStatic(ArrayType.class, "distinctFromOperator", MethodType.methodType(Boolean.TYPE, MethodHandle.class, Block.class, Block.class));
            INDETERMINATE = lookup.findStatic(ArrayType.class, "indeterminateOperator", MethodType.methodType(Boolean.TYPE, MethodHandle.class, Block.class, Boolean.TYPE));
            COMPARISON = lookup.findStatic(ArrayType.class, "comparisonOperator", MethodType.methodType(Long.TYPE, MethodHandle.class, Block.class, Block.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

