/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VariableWidthType;
import java.lang.invoke.MethodHandles;

public abstract class AbstractVariableWidthType
extends AbstractType
implements VariableWidthType {
    protected static final int EXPECTED_BYTES_PER_ENTRY = 32;
    protected static final TypeOperatorDeclaration DEFAULT_COMPARABLE_OPERATORS = TypeOperatorDeclaration.extractOperatorDeclaration(DefaultComparableOperators.class, MethodHandles.lookup(), Slice.class);
    protected static final TypeOperatorDeclaration DEFAULT_ORDERING_OPERATORS = TypeOperatorDeclaration.extractOperatorDeclaration(DefaultOrderingOperators.class, MethodHandles.lookup(), Slice.class);

    protected AbstractVariableWidthType(TypeSignature signature, Class<?> javaType) {
        super(signature, javaType);
    }

    @Override
    public VariableWidthBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        int expectedBytes = (int)Math.min((long)expectedEntries * (long)expectedBytesPerEntry, (long)maxBlockSizeInBytes);
        return new VariableWidthBlockBuilder(blockBuilderStatus, expectedBytesPerEntry == 0 ? expectedEntries : Math.min(expectedEntries, maxBlockSizeInBytes / expectedBytesPerEntry), expectedBytes);
    }

    @Override
    public VariableWidthBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 32);
    }

    private static class DefaultComparableOperators {
        private DefaultComparableOperators() {
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(Slice left, Slice right) {
            return left.equals((Object)right);
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
            int rightLength;
            int leftLength = leftBlock.getSliceLength(leftPosition);
            if (leftLength != (rightLength = rightBlock.getSliceLength(rightPosition))) {
                return false;
            }
            return leftBlock.equals(leftPosition, 0, rightBlock, rightPosition, 0, leftLength);
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(Slice left, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
            return DefaultComparableOperators.equalOperator(rightBlock, rightPosition, left);
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, Slice right) {
            int rightLength;
            int leftLength = leftBlock.getSliceLength(leftPosition);
            if (leftLength != (rightLength = right.length())) {
                return false;
            }
            return leftBlock.bytesEqual(leftPosition, 0, right, 0, leftLength);
        }

        @ScalarOperator(value=OperatorType.XX_HASH_64)
        private static long xxHash64Operator(Slice value) {
            return XxHash64.hash((Slice)value);
        }

        @ScalarOperator(value=OperatorType.XX_HASH_64)
        private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
            return block.hash(position, 0, block.getSliceLength(position));
        }
    }

    private static class DefaultOrderingOperators {
        private DefaultOrderingOperators() {
        }

        @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
        private static long comparisonOperator(Slice left, Slice right) {
            return left.compareTo(right);
        }

        @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
        private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
            int leftLength = leftBlock.getSliceLength(leftPosition);
            int rightLength = rightBlock.getSliceLength(rightPosition);
            return leftBlock.compareTo(leftPosition, 0, leftLength, rightBlock, rightPosition, 0, rightLength);
        }

        @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
        private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, Slice right) {
            int leftLength = leftBlock.getSliceLength(leftPosition);
            return leftBlock.bytesCompare(leftPosition, 0, leftLength, right, 0, right.length());
        }

        @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
        private static long comparisonOperator(Slice left, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
            int rightLength = rightBlock.getSliceLength(rightPosition);
            return -rightBlock.bytesCompare(rightPosition, 0, rightLength, left, 0, left.length());
        }
    }
}

